/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeSet;
import spoon.processing.Builder;
import spoon.reflect.Factory;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.builder.CtSnippetCompilationError;
import spoon.support.builder.support.CtVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetCompiler {
    public static <T> T compileStatement(CtCodeSnippetStatement st, Class<T> expectedType) throws CtSnippetCompilationError {
        CtStatement s = SnippetCompiler.compileStatement(st);
        if (expectedType.isAssignableFrom(s.getClass())) {
            return (T)s;
        }
        throw new CtSnippetCompilationError("Incorrect Type for snippet " + st.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileAndReplaceSnippetsIn(CtSimpleType<?> c) {
        Factory f = c.getFactory();
        CtSimpleType<?> workCopy = c;
        TreeSet<ModifierKind> backup = new TreeSet<ModifierKind>(workCopy.getModifiers());
        workCopy.getModifiers().remove((Object)ModifierKind.PUBLIC);
        try {
            SnippetCompiler.build(f, workCopy.toString());
        }
        finally {
            c.setModifiers(backup);
        }
    }

    public static CtStatement compileStatement(CtCodeSnippetStatement st) throws CtSnippetCompilationError {
        return SnippetCompiler.internalCompileStatement(st);
    }

    private static CtStatement internalCompileStatement(CtStatement st) {
        Factory f = st.getFactory();
        CtClass<?> w = SnippetCompiler.createWrapper(st, f);
        SnippetCompiler.compile(f, w);
        CtSimpleType c = f.Type().get("Wrapper");
        CtMethod wrapper = Query.getElements(c, new Filter<CtMethod>(){

            @Override
            public Class<CtMethod> getType() {
                return CtMethod.class;
            }

            @Override
            public boolean matches(CtMethod element) {
                return element.getSimpleName().equals("wrap");
            }
        }).get(0);
        CtStatement ret = wrapper.getBody().getStatements().get(0);
        c.getPackage().getTypes().remove(c);
        return ret;
    }

    private static CtClass<?> createWrapper(CtStatement st, Factory f) {
        CtClass w = f.Class().create("Wrapper");
        CtBlock body = f.Core().createBlock();
        body.getStatements().add(st);
        TreeSet<ModifierKind> x = new TreeSet<ModifierKind>();
        f.Method().create(w, x, f.Type().createReference(Void.TYPE), "wrap", new ArrayList(), new TreeSet<CtTypeReference<? extends Throwable>>(), body);
        return w;
    }

    private static void compile(Factory f, CtType<?> w) throws CtSnippetCompilationError {
        String contents = w.toString();
        SnippetCompiler.build(f, contents);
    }

    private static void build(Factory f, String contents, String name) {
        boolean success;
        Builder builder = f.getBuilder();
        try {
            builder.addInputSource(new CtVirtualFile(contents, name));
            success = builder.build();
        }
        catch (Exception e) {
            success = SnippetCompiler.debugCompilationError(f, e);
        }
        if (!success) {
            throw new CtSnippetCompilationError(builder.getProblems());
        }
    }

    private static void build(Factory f, String contents) throws CtSnippetCompilationError {
        SnippetCompiler.build(f, contents, "");
    }

    private static boolean debugCompilationError(Factory f, Exception e) {
        f.getEnvironment().debugMessage("BORKED SnippetCompilation");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(byteArrayOutputStream);
        e.printStackTrace(pw);
        String s = new String(byteArrayOutputStream.toByteArray());
        f.getEnvironment().debugMessage(s);
        boolean success = false;
        return success;
    }

    public static <T> CtExpression<T> compileExpression(CtCodeSnippetExpression<T> expr) throws CtSnippetCompilationError {
        Factory f = expr.getFactory();
        CtClass w = SnippetCompiler.createWrapper(expr, f);
        String contents = w.toString();
        SnippetCompiler.build(f, contents);
        CtSimpleType c = f.Type().get("Wrapper");
        CtMethod wrapper = Query.getElements(c, new Filter<CtMethod>(){

            @Override
            public Class<CtMethod> getType() {
                return CtMethod.class;
            }

            @Override
            public boolean matches(CtMethod element) {
                return element.getSimpleName().equals("wrap");
            }
        }).get(0);
        CtReturn ret = (CtReturn)wrapper.getBody().getStatements().get(0);
        c.getPackage().getTypes().remove(c);
        return ret.getReturnedExpression();
    }

    private static <R, B extends R> CtClass createWrapper(CtExpression<B> st, Factory f) {
        CtClass w = f.Class().create("Wrapper");
        CtBlock body = f.Core().createBlock();
        CtReturn<B> ret = f.Core().createReturn();
        ret.setReturnedExpression(st);
        body.getStatements().add(ret);
        TreeSet<ModifierKind> x = new TreeSet<ModifierKind>();
        f.Method().create(w, x, f.Type().createReference(Object.class), "wrap", new ArrayList(), new TreeSet<CtTypeReference<? extends Throwable>>(), body);
        return w;
    }
}

