/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder.support;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import spoon.support.builder.CtFile;
import spoon.support.builder.CtFolder;
import spoon.support.builder.FileFactory;
import spoon.support.builder.support.CtFileZip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtFolderZip
implements CtFolder {
    File f;
    List<CtFile> files;

    public CtFolderZip(File f) throws IOException {
        if (!f.isFile()) {
            throw new IOException(f.getName() + " is not a valid zip file");
        }
        this.f = f;
    }

    @Override
    public List<CtFile> getAllFiles() {
        return this.getFiles();
    }

    @Override
    public List<CtFile> getAllJavaFiles() {
        ArrayList<CtFile> files = new ArrayList<CtFile>();
        for (CtFile f : this.getFiles()) {
            if (!f.isJava()) continue;
            files.add(f);
        }
        return files;
    }

    @Override
    public List<CtFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<CtFile>();
            try {
                ZipEntry entry;
                ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.f)));
                while ((entry = zipInput.getNextEntry()) != null) {
                    int count;
                    int BUFFER = 2048;
                    ByteArrayOutputStream output = new ByteArrayOutputStream(2048);
                    byte[] data = new byte[2048];
                    while ((count = zipInput.read(data, 0, 2048)) != -1) {
                        output.write(data, 0, count);
                    }
                    output.flush();
                    output.close();
                    this.files.add(new CtFileZip(this, entry.getName(), output.toByteArray()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.files;
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public CtFolder getParent() {
        try {
            return FileFactory.createFolder(this.f.getParentFile());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<CtFolder> getSubFolder() {
        return new ArrayList<CtFolder>(0);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getPath() {
        return this.toString();
    }
}

