/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.eval;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import spoon.processing.Severity;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.eval.StepKind;
import spoon.reflect.eval.SymbolicEvaluationPath;
import spoon.reflect.eval.SymbolicEvaluationStack;
import spoon.reflect.eval.SymbolicEvaluator;
import spoon.reflect.eval.SymbolicHeap;
import spoon.reflect.eval.SymbolicInstance;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Query;
import spoon.support.query.TypeFilter;
import spoon.support.reflect.eval.ReturnException;
import spoon.support.reflect.eval.SymbolicWrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorSymbolicEvaluator
implements CtVisitor,
SymbolicEvaluator {
    List<CtTypeReference> statefullExternals = new ArrayList<CtTypeReference>();
    List<SymbolicEvaluationPath> paths = new ArrayList<SymbolicEvaluationPath>();
    private SymbolicInstance result = null;
    protected Stack<BranchingPoint> branchingPoints = new Stack();
    protected SymbolicEvaluationStack stack = new SymbolicEvaluationStack();
    protected SymbolicHeap heap = new SymbolicHeap();

    @Override
    public List<CtTypeReference> getStatefullExternals() {
        return this.statefullExternals;
    }

    private void startPath() {
        this.paths.add(new SymbolicEvaluationPath());
    }

    private SymbolicEvaluationPath getCurrentPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public List<SymbolicEvaluationPath> getPaths() {
        return this.paths;
    }

    @Override
    public void dumpPaths() {
        int i = 1;
        for (SymbolicEvaluationPath p : this.paths) {
            System.out.println("-- path " + i++);
            p.dump();
        }
    }

    private void resetCurrentEvaluation() {
        this.stack = new SymbolicEvaluationStack();
        this.heap.clear();
        SymbolicInstance.resetIds();
        this.result = null;
    }

    @Override
    public void reset() {
        this.resetCurrentEvaluation();
        this.branchingPoints.clear();
        this.paths.clear();
    }

    void enterExecutable(CtAbstractInvocation<?> caller, CtExecutableReference<?> eref, SymbolicInstance target, List<SymbolicInstance> args) {
        HashMap<CtVariableReference, SymbolicInstance> variables = new HashMap<CtVariableReference, SymbolicInstance>();
        CtExecutable<?> e = eref.getDeclaration();
        if (e != null) {
            int i = 0;
            for (CtParameter<?> ctParameter : e.getParameters()) {
                variables.put(ctParameter.getReference(), args.get(i++));
            }
            for (CtVariable<Object> ctVariable : Query.getElements(e.getBody(), new TypeFilter<CtVariable>(CtVariable.class))) {
                variables.put(ctVariable.getReference(), null);
            }
        }
        this.stack.enterFrame(caller, target, eref, args, variables);
        this.getCurrentPath().addStep(StepKind.ENTER, this);
    }

    void exitExecutable(CtExecutableReference<?> eref) {
        this.stack.setResult(this.result);
        this.getCurrentPath().addStep(StepKind.EXIT, this);
        this.stack.exitFrame();
    }

    Number convert(CtTypeReference<?> type, Number n) {
        if (type.getActualClass() == Integer.TYPE || type.getActualClass() == Integer.class) {
            return n.intValue();
        }
        if (type.getActualClass() == Byte.TYPE || type.getActualClass() == Byte.class) {
            return n.byteValue();
        }
        if (type.getActualClass() == Long.TYPE || type.getActualClass() == Long.class) {
            return n.longValue();
        }
        if (type.getActualClass() == Float.TYPE || type.getActualClass() == Float.class) {
            return Float.valueOf(n.floatValue());
        }
        if (type.getActualClass() == Short.TYPE || type.getActualClass() == Short.class) {
            return n.shortValue();
        }
        return n;
    }

    private BranchingPoint getBranchingPoint(CtElement ... branches) {
        if (!this.branchingPoints.isEmpty()) {
            boolean first = true;
            do {
                BranchingPoint bp = this.branchingPoints.peek();
                if (bp.stack.equals(this.stack) && ((Object)bp.branches).equals(Arrays.asList(branches))) {
                    bp.nextBranch();
                    return bp;
                }
                first = false;
            } while (!this.branchingPoints.isEmpty() && first);
            for (int i = this.branchingPoints.size() - 2; i >= 0; --i) {
                BranchingPoint bp = (BranchingPoint)this.branchingPoints.get(i);
                if (!bp.stack.equals(this.stack) || !((Object)bp.branches).equals(Arrays.asList(branches))) continue;
                return bp;
            }
        }
        BranchingPoint bp = new BranchingPoint(this.stack, branches);
        this.branchingPoints.push(bp);
        return bp;
    }

    protected SymbolicInstance evaluateBranches(CtElement ... branches) {
        BranchingPoint bp = this.getBranchingPoint(branches);
        this.result = bp.evaluate(this);
        if (this.branchingPoints.peek() == bp && bp.uncompletedBranches.size() == 1) {
            this.branchingPoints.pop();
        }
        return this.result;
    }

    @Override
    public SymbolicInstance evaluate(CtElement element) {
        if (element == null) {
            return null;
        }
        element.accept(this);
        return this.result;
    }

    @Override
    public void invoke(CtExecutable executable, SymbolicInstance ... args) {
        do {
            this.resetCurrentEvaluation();
            this.startPath();
            ArrayList<SymbolicInstance> cargs = new ArrayList<SymbolicInstance>();
            for (SymbolicInstance i : args) {
                cargs.add(i == null ? null : i.getClone());
            }
            SymbolicInstance target = this.heap.getType(this, executable.getDeclaringType().getReference());
            try {
                this.invoke(null, executable.getReference(), target, cargs);
            }
            catch (SymbolicWrappedException e) {
                // empty catch block
            }
        } while (!this.branchingPoints.isEmpty());
    }

    @Override
    public void invoke(SymbolicInstance target, CtExecutable executable, List<SymbolicInstance> args) {
        do {
            this.resetCurrentEvaluation();
            this.startPath();
            ArrayList<SymbolicInstance> cargs = null;
            if (args != null) {
                cargs = new ArrayList<SymbolicInstance>();
                for (SymbolicInstance i : args) {
                    cargs.add(i == null ? null : i.getClone());
                }
            }
            try {
                this.invoke(null, executable.getReference(), target, cargs);
            }
            catch (SymbolicWrappedException e) {
                e.printStackTrace();
            }
        } while (!this.branchingPoints.isEmpty());
    }

    boolean isGetter(CtExecutableReference e) {
        return e.getSimpleName().startsWith("get") && e.getParameterTypes().size() == 0;
    }

    boolean isSetter(CtExecutableReference e) {
        return e.getSimpleName().startsWith("set") && e.getParameterTypes().size() == 1;
    }

    boolean isStateFullExternal(CtTypeReference type) {
        for (CtTypeReference t : this.getStatefullExternals()) {
            if (!t.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> SymbolicInstance<T> invoke(CtAbstractInvocation<?> caller, CtExecutableReference<T> executable, SymbolicInstance target, List<SymbolicInstance> args) {
        this.enterExecutable(caller, executable, target, args);
        try {
            CtExecutable<T> decl = executable.getDeclaration();
            if (decl != null) {
                if (decl.getBody() != null) {
                    this.evaluate(decl.getBody());
                } else {
                    this.result = new SymbolicInstance<T>(this, executable.getType(), false);
                }
            } else {
                CtFieldReference<T> fref = null;
                if (this.isStateFullExternal(executable.getDeclaringType())) {
                    if (target != null && this.isGetter(executable)) {
                        SymbolicInstance r = null;
                        fref = executable.getFactory().Field().createReference(target.getConcreteType(), executable.getType(), executable.getSimpleName().substring(3));
                        r = this.heap.get(target.getFieldValue(fref));
                        this.result = r != null ? r : new SymbolicInstance<T>(this, executable.getType(), false);
                    } else if (target != null && this.isSetter(executable)) {
                        fref = executable.getFactory().Field().createReference(target.getConcreteType(), executable.getType(), executable.getSimpleName().substring(3));
                        target.setFieldValue(this.heap, fref, args.get(0));
                        this.result = new SymbolicInstance<T>(this, executable.getType(), false);
                    } else {
                        this.result = new SymbolicInstance<T>(this, executable.getType(), false);
                    }
                } else if (!executable.isConstructor()) {
                    this.result = new SymbolicInstance<T>(this, executable.getType(), false);
                }
            }
        }
        catch (ReturnException e) {
        }
        finally {
            this.exitExecutable(executable);
        }
        return this.result;
    }

    private void skip(CtElement e) {
        e.getFactory().getEnvironment().report(null, Severity.WARNING, e, "symbolic evaluator: ignoring unsupported element");
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.skip(annotation);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable impl) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.skip(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.skip(expression);
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.skip(statement);
    }

    public void visitCtAssert(CtAssert asserted) {
        this.skip(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        if (assignment.getAssigned() instanceof CtVariableAccess) {
            CtVariableReference vref = ((CtVariableAccess)assignment.getAssigned()).getVariable();
            SymbolicInstance res = this.evaluate(assignment.getAssignment());
            if (vref instanceof CtFieldReference) {
                this.stack.getThis().setFieldValue(this.heap, vref, res);
            } else {
                this.stack.setVariableValue(vref, res);
            }
            this.result = res;
        }
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        SymbolicInstance left = this.evaluate(operator.getLeftHandOperand());
        SymbolicInstance right = this.evaluate(operator.getRightHandOperand());
        switch (operator.getKind()) {
            case AND: 
            case OR: 
            case EQ: 
            case NE: 
            case GE: 
            case LE: 
            case GT: 
            case LT: 
            case INSTANCEOF: {
                SymbolicInstance<Boolean> bool;
                this.result = bool = new SymbolicInstance<Boolean>(this, operator.getFactory().Type().createReference(Boolean.TYPE), false);
                return;
            }
            case MINUS: 
            case MUL: 
            case DIV: {
                SymbolicInstance<Number> number;
                this.result = number = new SymbolicInstance<Number>(this, operator.getFactory().Type().createReference(Number.class), false);
                return;
            }
            case PLUS: {
                SymbolicInstance<Boolean> bool;
                if (left.getConcreteType().getActualClass() == String.class || right.getConcreteType().getActualClass() == String.class) {
                    SymbolicInstance<String> string;
                    this.result = string = new SymbolicInstance<String>(this, operator.getFactory().Type().createReference(String.class), false);
                    return;
                }
                this.result = bool = new SymbolicInstance<Boolean>(this, operator.getFactory().Type().createReference(Boolean.TYPE), false);
                return;
            }
        }
        throw new RuntimeException("unsupported operator");
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        for (CtStatement s : block.getStatements()) {
            this.evaluate(s);
        }
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.skip(breakStatement);
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.skip(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.skip(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        throw new RuntimeException("Not evaluable");
    }

    public void visitCtConstructor(CtConstructor c) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.skip(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.evaluate(doLoop.getBody());
        this.evaluate(doLoop.getLoopingExpression());
    }

    @Override
    public <T extends Enum> void visitCtEnum(CtEnum<T> ctEnum) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.skip(f);
    }

    boolean isAccessible(CtFieldReference<?> field) {
        return field.getDeclaringType().isAssignableFrom(this.stack.getThis().getConcreteType());
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> fieldAccess) {
        SymbolicInstance i;
        if (fieldAccess.getVariable().getSimpleName().equals("this")) {
            this.result = this.stack.getThis();
            return;
        }
        if (fieldAccess.getVariable().getSimpleName().equals("class")) {
            SymbolicInstance type;
            this.result = type = this.heap.getType(this, fieldAccess.getType());
            return;
        }
        SymbolicInstance<T> target = this.evaluate((CtElement)fieldAccess.getTarget());
        if (target == null && this.isAccessible(fieldAccess.getVariable())) {
            target = this.stack.getThis();
        }
        this.result = target != null && !target.isExternal() ? this.heap.get(target.getFieldValue(fieldAccess.getVariable())) : (i = new SymbolicInstance(this, fieldAccess.getType(), false));
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        for (CtStatement s : forLoop.getForInit()) {
            this.evaluate(s);
        }
        this.evaluate(forLoop.getExpression());
        this.evaluate(forLoop.getBody());
        for (CtStatement s : forLoop.getForUpdate()) {
            this.evaluate(s);
        }
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.evaluate(foreach.getBody());
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.evaluate(ifElement.getCondition());
        this.evaluateBranches(ifElement.getThenStatement(), ifElement.getElseStatement());
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtExecutableReference override;
        CtExecutableReference<Object> eref = invocation.getExecutable();
        ArrayList<SymbolicInstance> arguments = new ArrayList<SymbolicInstance>();
        for (CtExpression<?> expr : invocation.getArguments()) {
            SymbolicInstance o = this.evaluate(expr);
            arguments.add(o);
        }
        SymbolicInstance<?> target = this.evaluate((CtElement)invocation.getTarget());
        if (target != null && (override = eref.getOverridingExecutable(target.getConcreteType())) != null) {
            eref = override;
        }
        if (target == null) {
            target = eref.isStatic() ? this.heap.getType(this, eref.getDeclaringType()) : this.stack.getThis();
        }
        this.invoke(invocation, eref, (SymbolicInstance)target, arguments);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.result = new SymbolicInstance(this, literal.getType(), false);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.stack.setVariableValue(localVariable.getReference(), this.evaluate(localVariable.getDefaultExpression()));
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.skip(newArray);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        ArrayList<SymbolicInstance> arguments = new ArrayList<SymbolicInstance>();
        for (CtExpression<?> expr : newClass.getArguments()) {
            SymbolicInstance o = this.evaluate(expr);
            arguments.add(o);
        }
        SymbolicInstance i = new SymbolicInstance(this, newClass.getType(), false);
        this.heap.store(i);
        this.invoke(newClass, newClass.getExecutable(), i, arguments);
        this.result = i;
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignement(CtOperatorAssignment<T, A> assignment) {
        this.skip(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList<R> statements) {
        this.skip(statements);
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.result = this.evaluate(returnStatement.getReturnedExpression());
        throw new ReturnException(returnStatement);
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.skip(switchStatement);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.skip(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        throw new SymbolicWrappedException(this.evaluate(throwStatement.getThrownExpression()), throwStatement, this.getStack());
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        try {
            this.evaluate(tryBlock.getBody());
        }
        catch (ReturnException r) {
        }
        catch (SymbolicWrappedException e) {
            for (CtCatch c : tryBlock.getCatchers()) {
                if (!c.getParameter().getType().isAssignableFrom(e.getAbstractCause().getConcreteType())) continue;
                this.getStack().setVariableValue(c.getParameter().getReference(), e.getAbstractCause());
                this.evaluate(c.getBody());
                return;
            }
            throw e;
        }
        finally {
            this.evaluate(tryBlock.getFinalizer());
        }
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        throw new RuntimeException("Not evaluable");
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.evaluate(operator.getOperand());
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        CtVariableReference<T> vref = variableAccess.getVariable();
        this.result = this.stack.getVariableValue(vref);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.evaluate(whileLoop.getLoopingExpression());
        this.evaluate(whileLoop.getBody());
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.evaluate(conditional.getCondition());
        this.evaluate(conditional.getThenExpression());
        this.evaluate(conditional.getElseExpression());
    }

    @Override
    public SymbolicHeap getHeap() {
        return this.heap;
    }

    @Override
    public SymbolicEvaluationStack getStack() {
        return this.stack;
    }

    class BranchingPoint {
        public List<CtElement> branches;
        public SymbolicEvaluationStack stack;
        public List<CtElement> uncompletedBranches;
        public List<CtElement> completedBranches = new ArrayList<CtElement>();

        public BranchingPoint(SymbolicEvaluationStack stack, CtElement ... branches) {
            this.stack = new SymbolicEvaluationStack(stack);
            this.branches = Arrays.asList(branches);
            this.uncompletedBranches = new ArrayList<CtElement>(this.branches);
        }

        public SymbolicInstance evaluate(VisitorSymbolicEvaluator evaluator) {
            return evaluator.evaluate(this.uncompletedBranches.get(0));
        }

        public boolean nextBranch() {
            this.completedBranches.add(this.uncompletedBranches.get(0));
            this.uncompletedBranches.remove(0);
            return !this.uncompletedBranches.isEmpty();
        }

        public String toString() {
            return this.branches.toString();
        }
    }
}

