/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerHelper {
    private LoggerHelper() {
    }

    public static final Level getLevelOrParentLevel(Logger logger) {
        assert (logger != null);
        Level level = logger.getLevel();
        if (level == null) {
            assert (logger.getParent() != null);
            level = LoggerHelper.getLevelOrParentLevel(logger.getParent());
        }
        return level;
    }

    public static final List<Handler> getHandlersOrParentHanders(Logger logger) {
        ArrayList<Handler> handlers = new ArrayList<Handler>(Arrays.asList(logger.getHandlers()));
        if (logger.getUseParentHandlers() && logger.getParent() != null) {
            handlers.addAll(LoggerHelper.getHandlersOrParentHanders(logger.getParent()));
        }
        return handlers;
    }
}

