/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.log.formatter;

import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.ow2.petals.commons.log.LogData;
import org.ow2.petals.log.formatter.BasicLogDataAppender;
import org.ow2.petals.log.formatter.LogDataAppender;

public class LogDataFormatter
extends Formatter {
    private static final String LOGDATAFORMATTER_PROPERTY_NAME = LogDataFormatter.class.getName();
    private static final String LOGDATAFORMATTER_APPENDER_PROPERTY_NAME = LOGDATAFORMATTER_PROPERTY_NAME + ".appender";
    private static final String LOGDATAFORMATTER_STARTING_DELIMITER_PROPERTY_NAME = LOGDATAFORMATTER_PROPERTY_NAME + ".starting-delimiter";
    private static final String LOGDATAFORMATTER_DEFAULT_STARTING_DELIMITER = "";
    private static final String LOGDATAFORMATTER_ENDING_DELIMITER_PROPERTY_NAME = LOGDATAFORMATTER_PROPERTY_NAME + ".ending-delimiter";
    private static final String LOGDATAFORMATTER_DEFAULT_ENDING_DELIMITER = "";
    private static final String LOGDATA_CANONICAL_CLASSNAME = LogData.class.getCanonicalName();
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss,SSS 'GMT'Z", Locale.getDefault());
    private final Deque<LogDataAppender> dataAppenders;
    private String startingDelimiter;
    private String endingDelimiter;

    public LogDataFormatter() {
        LogDataAppender logDataAppender;
        LogManager manager;
        block7: {
            manager = LogManager.getLogManager();
            String appender = manager.getProperty(LOGDATAFORMATTER_APPENDER_PROPERTY_NAME);
            if (appender != null && !appender.trim().isEmpty()) {
                try {
                    Class<?> appenderClz = ClassLoader.getSystemClassLoader().loadClass(appender);
                    Object appenderObj = appenderClz.newInstance();
                    if (appenderObj instanceof LogDataAppender) {
                        logDataAppender = (LogDataAppender)appenderObj;
                        break block7;
                    }
                    logDataAppender = new BasicLogDataAppender();
                }
                catch (ClassNotFoundException e) {
                    logDataAppender = new BasicLogDataAppender();
                }
                catch (InstantiationException e) {
                    logDataAppender = new BasicLogDataAppender();
                }
                catch (IllegalAccessException e) {
                    logDataAppender = new BasicLogDataAppender();
                }
            } else {
                logDataAppender = new BasicLogDataAppender();
            }
        }
        this.dataAppenders = new LinkedList<LogDataAppender>();
        this.addLogDataAppender(logDataAppender);
        String tmpStartingDelimiter = manager.getProperty(LOGDATAFORMATTER_STARTING_DELIMITER_PROPERTY_NAME);
        this.startingDelimiter = tmpStartingDelimiter != null && !tmpStartingDelimiter.trim().isEmpty() ? tmpStartingDelimiter : "";
        String tmpEndingDelimiter = manager.getProperty(LOGDATAFORMATTER_ENDING_DELIMITER_PROPERTY_NAME);
        this.endingDelimiter = tmpEndingDelimiter != null && !tmpEndingDelimiter.trim().isEmpty() ? tmpEndingDelimiter : "";
    }

    public void setExtraParametersDelimiter(String startingDelimiter, String endingDelimiter) {
        this.startingDelimiter = startingDelimiter;
        this.endingDelimiter = endingDelimiter;
    }

    public final void addLogDataAppender(LogDataAppender logDataAppender) {
        assert (logDataAppender != null);
        this.dataAppenders.add(logDataAppender);
    }

    final LogDataAppender[] getLogDataAppenders() {
        return this.dataAppenders.toArray(new LogDataAppender[this.dataAppenders.size()]);
    }

    protected void formatExtraParameters(StringBuffer outBuffer, Map<String, Object> extraParameters) {
        Iterator<String> extraParametersKeySetIterator = extraParameters.keySet().iterator();
        if (extraParametersKeySetIterator.hasNext() && !this.dataAppenders.isEmpty()) {
            outBuffer.append(this.startingDelimiter);
            block0: while (extraParametersKeySetIterator.hasNext()) {
                String extraParameterKey = extraParametersKeySetIterator.next();
                Iterator<LogDataAppender> itAppender = this.dataAppenders.descendingIterator();
                while (itAppender.hasNext()) {
                    LogDataAppender appender = itAppender.next();
                    if (!appender.canAppend(extraParameters, extraParameterKey)) continue;
                    appender.append(outBuffer, extraParameters, extraParameterKey);
                    if (!extraParametersKeySetIterator.hasNext()) continue block0;
                    outBuffer.append(", ");
                    continue block0;
                }
            }
            outBuffer.append(this.endingDelimiter);
        }
    }

    private boolean isThereLogDataParameter(Object[] logParameters) {
        return logParameters != null && logParameters.length != 0 && logParameters[0] != null && ReflectionHelper.isOrInheritedFrom(logParameters[0].getClass(), (String)LOGDATA_CANONICAL_CLASSNAME);
    }

    protected void populateExtraParameters(Map<String, Object> extraParameters, LogRecord logRecord) {
        Object[] logParameters = logRecord.getParameters();
        if (this.isThereLogDataParameter(logParameters)) {
            extraParameters.putAll((Map)logParameters[0]);
        }
    }

    protected StringBuffer buildPattern(LogRecord record, Map<String, Object> flowParameters) {
        StringBuffer sb = new StringBuffer();
        String prefix = ExecutionContext.getProperties().getProperty("containerName");
        String formattedLog = prefix == null ? String.format("%s %s [%s] : %s", DATE_FORMAT.format(record.getMillis()), record.getLevel(), record.getLoggerName(), record.getMessage()) : String.format("%s %s %s [%s] : %s", prefix, DATE_FORMAT.format(record.getMillis()), record.getLevel(), record.getLoggerName(), record.getMessage());
        sb.append(formattedLog);
        if (flowParameters.size() > 0) {
            sb.append(' ');
        }
        return sb;
    }

    @Override
    public String format(LogRecord record) {
        LinkedHashMap<String, Object> extraParameters = new LinkedHashMap<String, Object>();
        this.populateExtraParameters(extraParameters, record);
        StringBuffer sb = this.buildPattern(record, extraParameters);
        this.formatExtraParameters(sb, extraParameters);
        sb.append("\n");
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            sw.flush();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    @Override
    public synchronized String formatMessage(LogRecord record) {
        Object[] extraParameters = record.getParameters();
        String result = null;
        if (this.isThereLogDataParameter(extraParameters)) {
            Object[] extraParametersWithoutLogData = Arrays.copyOfRange(extraParameters, 1, extraParameters.length);
            record.setParameters(extraParametersWithoutLogData);
            result = super.formatMessage(record);
            record.setParameters(extraParameters);
        } else {
            result = super.formatMessage(record);
        }
        return result;
    }
}

