/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.log.handler;

import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.ow2.petals.commons.log.Level;

public class PetalsFileHandler
extends StreamHandler {
    protected static final int offValue = Level.OFF.intValue();
    private static final String BASEDIR_PROPERTY_NAME = ".basedir";
    protected static final String DEFAULT_BASEDIR = "${petals.home}/logs/";
    private static final String FLOW_LOG_SUBDIR_PROPERTY_NAME = ".flows-subdir";
    protected static final String DEFAULT_FLOW_LOG_SUBDIR = "flow-monitoring";
    private static final String LOGFILENAME_PROPERTY_NAME = ".logFilename";
    protected static final String DEFAULT_LOGFILENAME = "petals.log";
    protected final String basedir;
    protected final String flowSubdir;
    protected final String logfilename;

    public PetalsFileHandler() throws IOException, PropertiesException {
        LogManager manager = LogManager.getLogManager();
        String basedir = manager.getProperty(this.getClass().getName() + BASEDIR_PROPERTY_NAME);
        this.basedir = basedir != null && !basedir.trim().isEmpty() ? PropertiesHelper.resolveString((String)basedir, (Properties)System.getProperties()) : PropertiesHelper.resolveString((String)DEFAULT_BASEDIR, (Properties)System.getProperties());
        String flowSubdir = manager.getProperty(this.getClass().getName() + FLOW_LOG_SUBDIR_PROPERTY_NAME);
        this.flowSubdir = flowSubdir != null && !flowSubdir.trim().isEmpty() ? PropertiesHelper.resolveString((String)flowSubdir, (Properties)System.getProperties()) : PropertiesHelper.resolveString((String)DEFAULT_FLOW_LOG_SUBDIR, (Properties)System.getProperties());
        String logfilename = manager.getProperty(this.getClass().getName() + LOGFILENAME_PROPERTY_NAME);
        if (logfilename != null && !logfilename.trim().isEmpty()) {
            if (logfilename.contains(File.separator)) {
                System.err.println("The log filename must not contain a file separator. Default value used: petals.log");
                this.logfilename = PropertiesHelper.resolveString((String)DEFAULT_LOGFILENAME, (Properties)System.getProperties());
            } else {
                this.logfilename = PropertiesHelper.resolveString((String)logfilename, (Properties)System.getProperties());
            }
        } else {
            this.logfilename = PropertiesHelper.resolveString((String)DEFAULT_LOGFILENAME, (Properties)System.getProperties());
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() >= levelValue && levelValue != offValue) {
            this.printLog(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printLog(LogRecord record) {
        block7: {
            try {
                File logFile = this.getMonitLogFile();
                if (logFile == null) break block7;
                try {
                    FileOutputStream fos = new FileOutputStream(logFile, true);
                    super.setOutputStream(fos);
                    try {
                        super.publish(record);
                    }
                    finally {
                        super.close();
                    }
                }
                catch (FileNotFoundException e) {
                    this.reportError(null, e, 4);
                }
            }
            catch (PropertiesException pe) {
                this.reportError(pe.getMessage(), (Exception)((Object)pe), 0);
            }
        }
    }

    private File getMonitLogFile() throws PropertiesException {
        Properties contextualProperties = PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties());
        String flowSubdir = this.getFlowSubDir(contextualProperties);
        File logFileDir = flowSubdir == null ? new File(this.basedir) : new File(this.basedir, flowSubdir);
        logFileDir.mkdirs();
        File logFile = new File(logFileDir, this.logfilename);
        return logFile;
    }

    protected String getFlowSubDir(Properties contextualProperties) {
        String flowInstanceId = contextualProperties.getProperty("flowInstanceId");
        if (flowInstanceId != null) {
            return this.flowSubdir + File.separator + flowInstanceId;
        }
        return null;
    }
}

