/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.log.handler;

import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.LogRecord;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.ow2.petals.commons.log.LogData;
import org.ow2.petals.commons.log.TraceCode;
import org.ow2.petals.log.handler.PetalsFileHandler;

public class PetalsPayloadDumperFileHandler
extends PetalsFileHandler {
    private static final String DUMP_FILE_EXTENSION = ".xml";
    private static final String FILENAME_SEPARATOR = "_";
    public static final String PAYLOAD_CONTENT_DUMP_FILE_LOGDATA_NAME = "payloadContentDumpFile";

    @Override
    public synchronized void publish(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() >= levelValue && levelValue != offValue) {
            this.dumpMessageExchange(record);
            this.printLog(record);
        }
    }

    private void dumpMessageExchange(LogRecord record) {
        Object[] logParameters = record.getParameters();
        if (logParameters != null && logParameters.length != 0 && logParameters[0] != null && logParameters[0] instanceof LogData) {
            LogData logData = (LogData)logParameters[0];
            String flowStepId = (String)logData.get("flowStepId");
            MessageExchange exchange = (MessageExchange)logData.get("flowExchange");
            if (exchange != null) {
                Source source;
                NormalizedMessage outNm = exchange.getMessage("out");
                NormalizedMessage inNm = exchange.getMessage("in");
                Fault faultNm = exchange.getFault();
                Source source2 = faultNm != null ? faultNm.getContent() : (outNm != null ? outNm.getContent() : (source = inNm != null ? inNm.getContent() : null));
                if (source != null) {
                    TraceCode traceCode = (TraceCode)((Object)logData.get("traceCode"));
                    File dumpFile = this.getDumpFile(traceCode, flowStepId);
                    logData.putData(PAYLOAD_CONTENT_DUMP_FILE_LOGDATA_NAME, dumpFile.getAbsolutePath());
                    dumpFile.getParentFile().mkdirs();
                    try {
                        Source faultMessageContentAsSource = SourceHelper.fork((Source)source);
                        SourceHelper.toFile((Source)faultMessageContentAsSource, (File)dumpFile);
                    }
                    catch (IOException e) {
                        this.reportError(e.getMessage(), e, 1);
                    }
                    catch (TransformerException e) {
                        this.reportError(e.getMessage(), e, 1);
                    }
                }
            }
        }
    }

    private final File getDumpFile(TraceCode traceCode, String flowStepId) {
        Properties contextualProperties = PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties());
        String dumpDir = this.basedir + File.separator + this.getFlowSubDir(contextualProperties);
        String dumpFileName = PetalsPayloadDumperFileHandler.getContextualDumpFileName(traceCode, flowStepId);
        return new File(dumpDir, dumpFileName);
    }

    private static final String getContextualDumpFileName(TraceCode traceCode, String flowStepId) {
        return (flowStepId == null ? "unknown" : flowStepId) + FILENAME_SEPARATOR + (Object)((Object)traceCode) + DUMP_FILE_EXTENSION;
    }
}

