/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingLoader
extends AbstractLoader {
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    private void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof BindingContainer) {
            HashMap<String, Interface> itfMap = new HashMap<String, Interface>();
            if (node instanceof InterfaceContainer) {
                for (Interface itf : ((InterfaceContainer)node).getInterfaces()) {
                    itfMap.put("this." + itf.getName(), itf);
                }
            }
            if (node instanceof ComponentContainer) {
                for (Component comp : ((ComponentContainer)node).getComponents()) {
                    if (!(comp instanceof InterfaceContainer)) continue;
                    for (Interface itf : ((InterfaceContainer)((Object)comp)).getInterfaces()) {
                        itfMap.put(comp.getName() + "." + itf.getName(), itf);
                    }
                }
            }
            for (Binding binding : ((BindingContainer)node).getBindings()) {
                this.checkBinding(binding, itfMap, context);
            }
            HashSet<String> fromItfs = new HashSet<String>();
            for (Binding binding : ((BindingContainer)node).getBindings()) {
                if (fromItfs.contains(binding.getFrom())) {
                    throw new ADLException("Multiple bindings from the same interface", binding);
                }
                fromItfs.add(binding.getFrom());
            }
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkBinding(Binding binding, Map<String, Interface> itfs, Map<Object, Object> context) throws ADLException {
        if (binding.getFrom() == null) {
            throw new ADLException("'from' interface missing", binding);
        }
        if (binding.getTo() == null) {
            throw new ADLException("'to' interface missing", binding);
        }
        Interface fromItf = this.getInterface(binding.getFrom(), itfs);
        Interface toItf = this.getInterface(binding.getTo(), itfs);
        if (fromItf == null && !binding.getFrom().endsWith(".component") && !binding.getFrom().endsWith("-controller")) {
            throw new ADLException("No such interface '" + binding.getFrom() + "'", binding);
        }
        if (toItf == null && !binding.getTo().endsWith(".component") && !binding.getTo().endsWith("-controller")) {
            throw new ADLException("No such interface '" + binding.getTo() + "'", binding);
        }
        if (fromItf != null && toItf != null) {
            this.checkBinding(binding, fromItf, toItf, context);
        }
    }

    protected void checkBinding(Binding binding, Interface fromItf, Interface toItf, Map<Object, Object> context) throws ADLException {
    }

    protected Interface getInterface(String name, Map<String, Interface> itfs) {
        return itfs.get(name);
    }
}

