/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;
import org.objectweb.fractal.adl.components.ComponentLoaderAttributes;
import org.objectweb.fractal.adl.merger.MergeException;
import org.objectweb.fractal.adl.merger.NodeMerger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLoader
extends AbstractLoader
implements ComponentLoaderAttributes {
    public NodeMerger nodeMergerItf;
    private final Map<String, String> nameAttributes = new HashMap<String, String>();

    public ComponentLoader() {
        this.nameAttributes.put("component", "name");
        this.nameAttributes.put("interface", "name");
        this.nameAttributes.put("binding", "from");
        this.nameAttributes.put("attribute", "name");
        this.nameAttributes.put("coordinates", "name");
    }

    @Override
    public String getNameAttributes() {
        StringBuffer b = new StringBuffer();
        for (Map.Entry<String, String> e : this.nameAttributes.entrySet()) {
            b.append(e.getKey());
            b.append(' ');
            b.append(e.getValue());
            b.append(' ');
        }
        return b.toString();
    }

    @Override
    public void setNameAttributes(String nameAttributes) {
        this.nameAttributes.clear();
        String key = null;
        int p = nameAttributes.indexOf(32);
        while (p != -1) {
            String s = nameAttributes.substring(0, p);
            if (key == null) {
                key = s;
            } else {
                this.nameAttributes.put(key, s);
                key = null;
            }
            nameAttributes = nameAttributes.substring(p + 1);
            p = nameAttributes.indexOf(32);
        }
        if (key != null) {
            this.nameAttributes.put(key, nameAttributes);
        }
    }

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        return this.load(new ArrayList<String>(), name, context);
    }

    protected Definition load(List<String> loaded, String name, Map<Object, Object> context) throws ADLException {
        if (loaded.contains(name)) {
            throw new ADLException("Cycle in definition references: " + loaded);
        }
        ArrayList<String> l = new ArrayList<String>(loaded);
        l.add(name);
        Definition d = this.clientLoader.load(name, context);
        if (d instanceof ComponentDefinition) {
            ComponentDefinition container = (ComponentDefinition)d;
            this.normalizeComponentContainer(container);
            this.resolveComponentContainer(l, container, container, context);
            if (container.getExtends() != null) {
                List<String> defs = this.parseDefinitions(container.getExtends(), container);
                try {
                    d = (Definition)this.nodeMergerItf.merge((Node)d, (Node)this.resolveDefinitions(l, defs, context), this.nameAttributes);
                }
                catch (ADLException e) {
                    throw new ADLException("Cannot load super definition(s)", container, e);
                }
                catch (MergeException e) {
                    throw new ADLException("Cannot merge super definition(s)", container, (Exception)((Object)e));
                }
                container = (ComponentDefinition)d;
                container.setExtends(null);
            }
            this.resolveSharedComponentContainer(container, container, context);
        }
        return d;
    }

    protected void normalizeComponentContainer(ComponentContainer container) throws ADLException {
        HashSet<String> names = new HashSet<String>();
        for (Component comp : container.getComponents()) {
            String name = comp.getName();
            if (name == null) {
                throw new ADLException("Component name missing", comp);
            }
            if (!names.add(name)) {
                throw new ADLException("Duplicated component name '" + name + "'", comp);
            }
            this.normalizeComponentContainer(comp);
        }
    }

    protected void resolveComponentContainer(List<String> loaded, ComponentContainer topLevelDefinition, ComponentContainer container, Map<Object, Object> context) throws ADLException {
        for (Component comp : container.getComponents()) {
            Node merged;
            Definition d;
            List<String> defs;
            this.resolveComponentContainer(loaded, topLevelDefinition, comp, context);
            String definition = comp.getDefinition();
            if (definition == null || (defs = this.parseDefinitions(definition, comp)).size() == 1 && this.isShared(defs.get(0))) continue;
            comp.setDefinition(null);
            comp.astSetDecoration("definition", definition);
            try {
                d = this.resolveDefinitions(loaded, defs, context);
            }
            catch (ADLException e) {
                throw new ADLException("Cannot load referenced definition(s)", comp, e);
            }
            try {
                merged = this.nodeMergerItf.merge((Node)comp, (Node)d, this.nameAttributes);
            }
            catch (MergeException e) {
                throw new ADLException("Cannot merge component with definition(s)", comp, (Exception)((Object)e));
            }
            if (merged == comp) continue;
            container.removeComponent(comp);
            container.addComponent((Component)merged);
        }
    }

    protected void resolveSharedComponentContainer(ComponentContainer topLevelDefinition, ComponentContainer container, Map<Object, Object> context) throws ADLException {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Node merged;
            Component c;
            List<String> defs;
            Component comp = comps[i];
            this.resolveSharedComponentContainer(topLevelDefinition, comp, context);
            String definition = comp.getDefinition();
            if (definition == null || (defs = this.parseDefinitions(definition, comp)).size() != 1 || !this.isShared(defs.get(0))) continue;
            comp.setDefinition(null);
            comp.astSetDecoration("definition", definition);
            if (definition.startsWith("./")) {
                definition = definition.substring(2);
            }
            if ((c = this.getPathComponent(topLevelDefinition, definition)) == null) {
                throw new ADLException("No such component", comp);
            }
            if (!c.getName().equals(comps[i].getName())) {
                throw new ADLException("Shared components with distinct names not yet supported", comp);
            }
            HashMap<Node, Node> replacements = new HashMap<Node, Node>();
            try {
                merged = this.nodeMergerItf.merge((Node)comp, (Node)c, this.nameAttributes);
            }
            catch (MergeException e) {
                throw new ADLException("Cannot merge shared component", comp, (Exception)((Object)e));
            }
            if (comp != merged) {
                replacements.put(comp, merged);
            }
            replacements.put(c, merged);
            this.replaceComponents(topLevelDefinition, replacements);
        }
    }

    protected List<String> parseDefinitions(String nameList, Node n) throws ADLException {
        ArrayList<String> l = new ArrayList<String>();
        int p = nameList.indexOf(44);
        while (p != -1) {
            l.add(nameList.substring(0, p));
            nameList = nameList.substring(p + 1);
            p = nameList.indexOf(44);
        }
        l.add(nameList);
        return l;
    }

    protected boolean isShared(String definition) {
        return definition.indexOf(47) != -1;
    }

    protected Definition resolveDefinitions(List<String> loaded, List<String> nameList, Map<Object, Object> context) throws ADLException {
        Definition d = this.load(loaded, nameList.get(0), context);
        for (int i = 1; i < nameList.size(); ++i) {
            Definition e = this.load(loaded, nameList.get(i), context);
            try {
                d = (Definition)this.nodeMergerItf.merge((Node)e, (Node)d, this.nameAttributes);
                continue;
            }
            catch (MergeException me) {
                throw new ADLException("Cannot merge component with definition(s)", d, (Exception)((Object)me));
            }
        }
        return d;
    }

    protected Component getComponent(ComponentContainer container, String name) {
        for (Component comp : container.getComponents()) {
            if (!comp.getName().equals(name)) continue;
            return comp;
        }
        return null;
    }

    protected Component getPathComponent(ComponentContainer container, String name) {
        int p = name.indexOf(47);
        if (p == -1) {
            return this.getComponent(container, name);
        }
        Component parent = this.getComponent(container, name.substring(0, p));
        if (parent == null) {
            return null;
        }
        return this.getPathComponent(parent, name.substring(p + 1));
    }

    protected ComponentContainer replaceComponents(ComponentContainer container, Map<Node, Node> replacements) {
        Component[] comps;
        Node node = replacements.get(container);
        if (node != null) {
            return (ComponentContainer)node;
        }
        for (Component element : comps = container.getComponents()) {
            container.removeComponent(element);
        }
        for (Component element : comps) {
            container.addComponent((Component)this.replaceComponents(element, replacements));
        }
        return container;
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("node-merger".equals(s)) {
            this.nodeMergerItf = (NodeMerger)o;
        } else {
            super.bindFc(s, o);
        }
    }

    @Override
    public String[] listFc() {
        String[] superList = super.listFc();
        String[] list = new String[superList.length + 1];
        list[0] = "node-merger";
        System.arraycopy(superList, 0, list, 1, superList.length);
        return list;
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("node-merger".equals(s)) {
            return this.nodeMergerItf;
        }
        return super.lookupFc(s);
    }

    @Override
    public void unbindFc(String s) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("node-merger".equals(s)) {
            this.nodeMergerItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

