/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.task.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.task.core.Scheduler;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskExecutionException;
import org.objectweb.fractal.task.core.TaskMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicScheduler
implements Scheduler {
    @Override
    public void schedule(Task[] tasks, Map<Object, Object> context) throws TaskExecutionException {
        this.doSchedule(this.prepareScheduling(tasks), context);
    }

    protected Task[] prepareScheduling(Task[] tasks) {
        ArrayList<Task> result = new ArrayList<Task>();
        HashMap allNextTasks = new HashMap();
        HashMap allPreviousTasks = new HashMap();
        for (Task currentTask : tasks) {
            TaskMap.TaskHole[] previousTaskHoles;
            allNextTasks.put(currentTask, new ArrayList());
            ArrayList<Task> tl = new ArrayList<Task>();
            for (TaskMap.TaskHole element0 : previousTaskHoles = currentTask.getPreviousTasks()) {
                tl.add(element0.getTask());
            }
            allPreviousTasks.put(currentTask, tl);
        }
        for (Task currentTask : tasks) {
            TaskMap.TaskHole[] previousTaskHoles;
            for (TaskMap.TaskHole element0 : previousTaskHoles = currentTask.getPreviousTasks()) {
                List tl = (List)allNextTasks.get(element0.getTask());
                tl.add(currentTask);
            }
        }
        while (allPreviousTasks.size() != 0) {
            for (Task currentTask : tasks) {
                Task[] nextTasks;
                List previousTaskList = (List)allPreviousTasks.get(currentTask);
                if (previousTaskList == null || previousTaskList.size() != 0) continue;
                result.add(currentTask);
                List al = (List)allNextTasks.get(currentTask);
                for (Task nextTask : nextTasks = al.toArray(new Task[al.size()])) {
                    previousTaskList = (List)allPreviousTasks.get(nextTask);
                    previousTaskList.remove(currentTask);
                }
                allPreviousTasks.remove(currentTask);
            }
        }
        return result.toArray(new Task[result.size()]);
    }

    protected void doSchedule(Task[] tasks, Map<Object, Object> context) throws TaskExecutionException {
        for (Task currentTask : tasks) {
            try {
                currentTask.execute(context);
            }
            catch (Exception e) {
                throw new TaskExecutionException(currentTask, e);
            }
        }
    }
}

