/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
implements Node {
    private final String type;
    private String source;
    private Map<String, Object> decorations;

    protected AbstractNode(String type) {
        this.type = type;
    }

    private Map<String, Object> decorations() {
        if (this.decorations == null) {
            this.decorations = new HashMap<String, Object>();
        }
        return this.decorations;
    }

    @Override
    public String astGetType() {
        return this.type;
    }

    @Override
    public String astGetSource() {
        return this.source;
    }

    @Override
    public void astSetSource(String source) {
        this.source = source;
    }

    @Override
    public Object astGetDecoration(String name) {
        if (this.decorations == null) {
            return null;
        }
        return this.decorations().get(name);
    }

    @Override
    public Map<String, Object> astGetDecorations() {
        if (this.decorations == null) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>(this.decorations());
    }

    @Override
    public void astSetDecoration(String name, Object decoration) {
        this.decorations().put(name, decoration);
    }

    @Override
    public void astSetDecorations(Map<String, Object> decorations) {
        if (decorations.size() > 0) {
            this.decorations().putAll(decorations);
        }
    }

    public String toString() {
        Map<String, String> attributes = this.astGetAttributes();
        String name = attributes.get("name");
        if (name != null) {
            return this.type + '<' + name + '>';
        }
        if (attributes.size() == 1) {
            Map.Entry<String, String> attr = attributes.entrySet().iterator().next();
            return this.type + '<' + attr.getKey() + '=' + attr.getValue() + '>';
        }
        return this.type + '@' + System.identityHashCode(this);
    }
}

