/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.IdentityHashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeUtil {
    private NodeUtil() {
    }

    public static <T extends Node> T cloneNode(T node) {
        T newNode = NodeUtil.cloneNodeState(node);
        for (String subNodeType : node.astGetNodeTypes()) {
            for (Node subNode : node.astGetNodes(subNodeType)) {
                if (subNode == null) continue;
                newNode.astAddNode(subNode);
            }
        }
        return newNode;
    }

    public static <T extends Node> T cloneTree(T node) {
        T newNode = NodeUtil.cloneNodeState(node);
        for (String subNodeType : node.astGetNodeTypes()) {
            for (Node subNode : node.astGetNodes(subNodeType)) {
                if (subNode == null) continue;
                newNode.astAddNode(NodeUtil.cloneTree(subNode));
            }
        }
        return newNode;
    }

    public static <T extends Node> T cloneGraph(T node) {
        return NodeUtil.cloneGraph(node, new IdentityHashMap<Node, Node>());
    }

    private static <T extends Node> T cloneGraph(T node, Map<Node, Node> clonedNodes) {
        Node clone = clonedNodes.get(node);
        if (clone == null) {
            clone = NodeUtil.cloneNodeState(node);
            for (String subNodeType : node.astGetNodeTypes()) {
                for (Node subNode : node.astGetNodes(subNodeType)) {
                    if (subNode == null) continue;
                    clone.astAddNode(NodeUtil.cloneGraph(subNode, clonedNodes));
                }
            }
            clonedNodes.put(node, clone);
        }
        return (T)clone;
    }

    private static <T extends Node> T cloneNodeState(T node) {
        Node newNode = node.astNewInstance();
        newNode.astSetAttributes(node.astGetAttributes());
        newNode.astSetDecorations(node.astGetDecorations());
        newNode.astSetSource(node.astGetSource());
        return (T)newNode;
    }

    public static <T> T castNode(Object node, Class<T> nodeClass) {
        try {
            return nodeClass.cast(node);
        }
        catch (ClassCastException e) {
            throw new InvalidNodeTypeException(node, nodeClass);
        }
    }

    public static <T> T castNodeError(Object node, Class<T> nodeClass) {
        try {
            return nodeClass.cast(node);
        }
        catch (ClassCastException e) {
            throw new InvalidNodeTypeError(node, nodeClass);
        }
    }

    private static String getErrorMessage(Object node, Class<?> nodeClass) {
        StringBuilder sb = new StringBuilder("The given node does not implement the expected type.");
        sb.append(" Expected type: '").append(nodeClass.getName()).append("'.");
        if (node instanceof Node) {
            sb.append(" Node location: '").append(((Node)node).astGetSource()).append("'.");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidNodeTypeError
    extends Error {
        InvalidNodeTypeError(Object node, Class<?> nodeClass) {
            super(NodeUtil.getErrorMessage(node, nodeClass));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidNodeTypeException
    extends ClassCastException {
        InvalidNodeTypeException(Object node, Class<?> nodeClass) {
            super(NodeUtil.getErrorMessage(node, nodeClass));
        }
    }
}

