/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInputStream {
    protected final ObjectInputStream in;
    protected final ArrayList<Node> nodeIds = new ArrayList();
    protected final Map<Integer, Class<? extends Node>> nodeClassIds = new IdentityHashMap<Integer, Class<? extends Node>>();
    protected InputNodeClassLoader nodeClassLoader;

    public NodeInputStream(ObjectInputStream in) throws IOException {
        this.in = in;
        in.reset();
        this.nodeClassLoader = new InputNodeClassLoader(this.getClass().getClassLoader());
    }

    public NodeInputStream(ObjectInputStream in, ClassLoader parentLoader) throws IOException {
        this.in = in;
        in.reset();
        this.nodeClassLoader = new InputNodeClassLoader(parentLoader);
    }

    public NodeInputStream(InputStream in) throws IOException {
        if (in instanceof ObjectInputStream) {
            this.in = (ObjectInputStream)in;
            this.in.reset();
        } else {
            this.in = new ObjectInputStream(in);
        }
        this.nodeClassLoader = new InputNodeClassLoader(this.getClass().getClassLoader());
    }

    public NodeInputStream(InputStream in, ClassLoader parentLoader) throws IOException {
        if (in instanceof ObjectInputStream) {
            this.in = (ObjectInputStream)in;
            this.in.reset();
        } else {
            this.in = new ObjectInputStream(in);
        }
        this.nodeClassLoader = new InputNodeClassLoader(parentLoader);
    }

    public synchronized void reset() throws IOException {
        this.nodeClassIds.clear();
    }

    public synchronized void close() throws IOException {
        this.reset();
        this.in.close();
    }

    public synchronized Node readNode() throws IOException, ClassNotFoundException {
        byte b = this.in.readByte();
        if (b == 16) {
            return null;
        }
        if (b == 17) {
            Node node;
            Class<? extends Node> nodeClass = this.readNodeClass();
            try {
                node = nodeClass.newInstance();
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            this.readNodeData(node);
            this.nodeIds.add(node);
            return node;
        }
        if (b == 18) {
            int id = this.in.readInt();
            if (id < 0 || id >= this.nodeIds.size()) {
                throw new IOException("Stream error");
            }
            return this.nodeIds.get(id);
        }
        throw new IOException("Stream error");
    }

    protected Class<? extends Node> readNodeClass() throws IOException, ClassNotFoundException {
        byte b = this.in.readByte();
        if (b == 112) {
            int length = this.in.readInt();
            byte[] bytecode = new byte[length];
            this.in.readFully(bytecode);
            Class<? extends Node> nodeClass = this.nodeClassLoader.defineNodeClass(bytecode);
            this.nodeClassIds.put(this.nodeClassIds.size(), nodeClass);
            return nodeClass;
        }
        if (b == 113) {
            int nodeClassId = this.in.readInt();
            Class<? extends Node> nodeClass = this.nodeClassIds.get(nodeClassId);
            if (nodeClass == null) {
                throw new IOException("Stream Error");
            }
            return nodeClass;
        }
        throw new IOException("Stream Error");
    }

    protected void readNodeData(Node node) throws IOException, ClassNotFoundException {
        byte decoState;
        Object value;
        String name;
        node.astSetSource((String)this.in.readObject());
        int nbAttributes = this.in.readInt();
        HashMap<String, String> attributes = new HashMap<String, String>(nbAttributes);
        for (int i = 0; i < nbAttributes; ++i) {
            name = this.in.readUTF();
            value = (String)this.in.readObject();
            attributes.put(name, (String)value);
        }
        node.astSetAttributes(attributes);
        while ((decoState = this.in.readByte()) != 34) {
            name = this.in.readUTF();
            if (decoState == 32) {
                value = this.in.readObject();
            } else if (decoState == 33) {
                value = this.readNode();
            } else {
                throw new IOException("Stream Error");
            }
            node.astSetDecoration(name, value);
        }
        int nbSubNodes = this.in.readInt();
        for (int i = 0; i < nbSubNodes; ++i) {
            node.astAddNode(this.readNode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InputNodeClassLoader
    extends ClassLoader {
        final Set<String> classNames = new HashSet<String>();
        InputNodeClassLoader delegate;

        InputNodeClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<? extends Node> defineNodeClass(byte[] bytecode) {
            ClassReader classReader = new ClassReader(bytecode);
            String className = classReader.getClassName().replace('/', '.');
            return this.defineNodeClass(className, bytecode);
        }

        private Class<? extends Node> defineNodeClass(String className, byte[] bytecode) throws ClassFormatError {
            if (this.classNames.add(className)) {
                Class<?> c = this.defineClass(className, bytecode, 0, bytecode.length);
                return c.asSubclass(Node.class);
            }
            if (this.delegate == null) {
                this.delegate = new InputNodeClassLoader(this.getParent());
            }
            return this.delegate.defineNodeClass(className, bytecode);
        }
    }
}

