/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.merger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.merger.MergeException;
import org.objectweb.fractal.adl.merger.MergeableDecoration;
import org.objectweb.fractal.adl.merger.NodeMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMergerImpl
implements NodeMerger {
    private final MergeClassLoader mergeClassLoader;
    private final Map<Class<?>, Map<String, SubNodeArity>> subNodeArityCache = new IdentityHashMap();

    public NodeMergerImpl() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        this.mergeClassLoader = new MergeClassLoader(classLoader);
    }

    @Override
    public Node merge(Node elem, Node superElem, Map<String, String> idAttributes) throws MergeException {
        HashMap<Node, MergeInfo> infos = new HashMap<Node, MergeInfo>();
        MergeInfo elemInfo = this.computeMergeInfos(elem, superElem, infos, idAttributes);
        for (MergeInfo info : infos.values()) {
            info.createResultNode(this.mergeClassLoader);
        }
        Node n = this.initMergedNodes(elemInfo, infos);
        return n;
    }

    protected MergeInfo computeMergeInfos(Node elem, Node superElem, Map<Node, MergeInfo> infos, Map<String, String> idAttributes) throws MergeException {
        MergeInfo info = infos.get(elem);
        if (info == null) {
            info = infos.get(superElem);
            if (info != null) {
                info.resetElem(elem);
            } else {
                info = new MergeInfo(elem);
                info.addSuperNode(superElem);
                infos.put(superElem, info);
            }
            infos.put(elem, info);
        } else if (info.addSuperNode(superElem)) {
            infos.put(superElem, info);
        } else {
            return info;
        }
        HashSet<String> nodeTypes = new HashSet<String>();
        nodeTypes.addAll(Arrays.asList(elem.astGetNodeTypes()));
        nodeTypes.addAll(Arrays.asList(superElem.astGetNodeTypes()));
        for (String nodeType : nodeTypes) {
            SubNodeArity arity;
            Node[] superNodes = superElem.astGetNodes(nodeType);
            Node[] nodes = elem.astGetNodes(nodeType);
            if ((superNodes == null || superNodes.length == 0) && (nodes == null || nodes.length == 0)) continue;
            if (superNodes == null) {
                superNodes = new Node[]{};
            }
            if (nodes == null) {
                nodes = new Node[]{};
            }
            if ((arity = this.checkArityCompatibility(elem, superElem, nodeType)) == SubNodeArity.ONE) {
                Node superNode;
                assert (superNodes.length <= 1);
                assert (nodes.length <= 1);
                Node node = nodes.length > 0 ? nodes[0] : null;
                Node node2 = superNode = superNodes.length > 0 ? superNodes[0] : null;
                if (superNode != null) {
                    if (node == null) {
                        this.computeInhertedSubNodeMergeInfos(superNode, info, nodeType, infos);
                        continue;
                    }
                    this.computeMergedSubNodesMergeInfos(node, superNode, info, infos, idAttributes, nodeType);
                    continue;
                }
                if (node == null) continue;
                this.computeSubNodeMergeInfos(node, info, nodeType, infos);
                continue;
            }
            LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>();
            for (Node node : nodes) {
                nodeSet.add(node);
            }
            for (Node superNode : superNodes) {
                Node overridingNode = this.findOverridingNode(superNode, nodes, nodeType, idAttributes);
                if (overridingNode != null) {
                    this.computeMergedSubNodesMergeInfos(overridingNode, superNode, info, infos, idAttributes, nodeType);
                    nodeSet.remove(overridingNode);
                    continue;
                }
                this.computeInhertedSubNodeMergeInfos(superNode, info, nodeType, infos);
            }
            for (Node node : nodeSet) {
                this.computeSubNodeMergeInfos(node, info, nodeType, infos);
            }
        }
        return info;
    }

    protected Node findOverridingNode(Node superNode, Node[] nodes, String nodeType, Map<String, String> idAttributes) {
        String superName;
        String nameAttr = idAttributes.get(nodeType);
        if (nameAttr != null && (superName = superNode.astGetAttributes().get(nameAttr)) != null) {
            for (Node node : nodes) {
                String name = node.astGetAttributes().get(nameAttr);
                if (name == null || !name.equals(superName)) continue;
                return node;
            }
        }
        return null;
    }

    protected void computeSubNodeMergeInfos(Node subNode, MergeInfo parentInfo, String subNodeType, Map<Node, MergeInfo> infos) throws MergeException {
        parentInfo.addSubNodeInfo(this.computeMergeInfos(subNode, infos));
    }

    protected void computeInhertedSubNodeMergeInfos(Node inheritedSubNode, MergeInfo parentInfo, String subNodeType, Map<Node, MergeInfo> infos) throws MergeException {
        parentInfo.addSubNodeInfo(this.computeMergeInfos(inheritedSubNode, infos));
    }

    protected void computeMergedSubNodesMergeInfos(Node subNode, Node inheritedSubNode, MergeInfo parentInfo, Map<Node, MergeInfo> infos, Map<String, String> idAttributes, String subNodeType) throws MergeException {
        parentInfo.addSubNodeInfo(this.computeMergeInfos(subNode, inheritedSubNode, infos, idAttributes));
    }

    protected MergeInfo computeMergeInfos(Node node, Map<Node, MergeInfo> infos) throws MergeException {
        MergeInfo info = infos.get(node);
        if (info == null) {
            info = new MergeInfo(node);
            infos.put(node, info);
            for (String type : node.astGetNodeTypes()) {
                for (Node subNode : node.astGetNodes(type)) {
                    if (subNode == null) continue;
                    info.addSubNodeInfo(this.computeMergeInfos(subNode, infos));
                }
            }
        }
        return info;
    }

    protected Node initMergedNodes(MergeInfo info, Map<Node, MergeInfo> infos) throws MergeException {
        if (info.done) {
            return info.result;
        }
        info.done = true;
        Node elem = info.elem;
        Node result = info.result;
        result.astSetSource(elem.astGetSource());
        Map<String, String> resultAttrs = elem.astGetAttributes();
        for (Node superNode : info.getSuperNodes()) {
            for (Map.Entry<String, String> entry : superNode.astGetAttributes().entrySet()) {
                String name = entry.getKey();
                String superValue = entry.getValue();
                String value = resultAttrs.get(name);
                if (superValue == null || value != null) continue;
                resultAttrs.put(name, superValue);
            }
        }
        result.astSetAttributes(resultAttrs);
        Map<String, Object> resultDecors = elem.astGetDecorations();
        for (Node superNode : info.getSuperNodes()) {
            for (Map.Entry<String, Object> entry : superNode.astGetDecorations().entrySet()) {
                String name = entry.getKey();
                Object superValue = entry.getValue();
                Object value = resultDecors.get(name);
                if (superValue instanceof MergeableDecoration) {
                    resultDecors.put(name, ((MergeableDecoration)superValue).mergeDecoration(value));
                    continue;
                }
                if (superValue == null || value != null) continue;
                resultDecors.put(name, superValue);
            }
        }
        result.astSetDecorations(resultDecors);
        for (MergeInfo subNodeInfo : info.getSubNodeInfos()) {
            result.astAddNode(this.initMergedNodes(subNodeInfo, infos));
        }
        return result;
    }

    private SubNodeArity getSubNodeArity(Node node, String subNodeType) {
        SubNodeArity arity;
        Class<?> nodeClass = node.getClass();
        Map<String, SubNodeArity> arities = this.subNodeArityCache.get(nodeClass);
        if (arities == null) {
            arities = new HashMap<String, SubNodeArity>();
            this.subNodeArityCache.put(nodeClass, arities);
        }
        if ((arity = arities.get(subNodeType)) == null) {
            try {
                nodeClass.getMethod("get" + Character.toUpperCase(subNodeType.charAt(0)) + subNodeType.substring(1), new Class[0]);
                arity = SubNodeArity.ONE;
            }
            catch (Exception e) {
                try {
                    nodeClass.getMethod("get" + Character.toUpperCase(subNodeType.charAt(0)) + subNodeType.substring(1) + 's', new Class[0]);
                    arity = SubNodeArity.MANY;
                }
                catch (Exception e1) {
                    arity = SubNodeArity.NONE;
                }
            }
            arities.put(subNodeType, arity);
        }
        return arity;
    }

    private SubNodeArity checkArityCompatibility(Node node, Node superNode, String subNodeType) throws MergeException {
        SubNodeArity nodeArity = this.getSubNodeArity(node, subNodeType);
        if (node.getClass() == superNode.getClass()) {
            assert (nodeArity != SubNodeArity.NONE);
            return nodeArity;
        }
        SubNodeArity superNodeArity = this.getSubNodeArity(superNode, subNodeType);
        if (nodeArity == SubNodeArity.NONE) {
            assert (superNodeArity != SubNodeArity.NONE);
            return superNodeArity;
        }
        if (superNodeArity == SubNodeArity.NONE) {
            return nodeArity;
        }
        if (nodeArity != superNodeArity) {
            throw new MergeException("Cannot merge AST, the arity of sub nodes of type '" + subNodeType + "' is not the same for node '" + node.astGetSource() + "' and node '" + superNode.astGetSource() + "'. Check DTDs");
        }
        return nodeArity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergeClassLoader
    extends NodeClassLoader {
        MergeClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<?> mergeNodeClasses(String astNodeName, Set<Class<? extends Node>> nodeClasses) throws ClassNotFoundException {
            int hash = 0;
            for (Class<? extends Node> nodeClass : nodeClasses) {
                hash = 17 * (hash + nodeClass.hashCode());
            }
            String name = "org.objectweb.fractal.adl.merged.Merged" + Integer.toHexString(hash);
            try {
                return this.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                HashSet<String> itfs = new HashSet<String>();
                for (Class<? extends Node> nodeClass : nodeClasses) {
                    for (Class<?> itf : nodeClass.getInterfaces()) {
                        itfs.add(Type.getInternalName(itf));
                    }
                }
                ClassWriter cw = this.generateClass(name, astNodeName, Type.getInternalName(AbstractNode.class), itfs.toArray(new String[itfs.size()]));
                return this.defineClass(name, cw.toByteArray());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MergeInfo {
        Node elem;
        Node superElem;
        Set<Node> additionalSuperElems;
        Node result;
        List<MergeInfo> subNodeInfos;
        boolean done;
        Set<Class<? extends Node>> nodeClasses;
        final SuperElemIterator superElemIterator = new SuperElemIterator();

        MergeInfo(Node elem) {
            assert (elem != null);
            this.elem = elem;
        }

        void resetElem(Node newElem) {
            this.superElemIterator.modification = true;
            assert (newElem != null);
            assert (this.elem != null);
            Node oldElem = this.elem;
            this.elem = newElem;
            if (this.superElem == null) {
                assert (this.additionalSuperElems == null);
                this.superElem = oldElem;
            } else if (this.additionalSuperElems == null) {
                this.additionalSuperElems = new LinkedHashSet<Node>();
                this.additionalSuperElems.add(this.superElem);
                this.superElem = oldElem;
            } else {
                Set<Node> oldSuperNodes = this.additionalSuperElems;
                this.additionalSuperElems = new LinkedHashSet<Node>();
                this.additionalSuperElems.add(this.superElem);
                this.additionalSuperElems.addAll(oldSuperNodes);
                this.superElem = oldElem;
            }
            if (newElem.getClass() != oldElem.getClass()) {
                if (this.nodeClasses == null) {
                    this.nodeClasses = new HashSet<Class<? extends Node>>();
                    this.nodeClasses.add(oldElem.getClass());
                }
                this.nodeClasses.add(newElem.getClass());
            }
        }

        boolean addSuperNode(Node superNode) {
            boolean r;
            this.superElemIterator.modification = true;
            assert (superNode != null);
            if (this.superElem == null) {
                assert (this.additionalSuperElems == null);
                this.superElem = superNode;
                r = true;
            } else {
                if (this.additionalSuperElems == null) {
                    this.additionalSuperElems = new LinkedHashSet<Node>();
                }
                r = this.additionalSuperElems.add(superNode);
            }
            if (superNode.getClass() != this.elem.getClass()) {
                if (this.nodeClasses == null) {
                    this.nodeClasses = new HashSet<Class<? extends Node>>();
                    this.nodeClasses.add(this.elem.getClass());
                }
                this.nodeClasses.add(superNode.getClass());
            }
            return r;
        }

        protected Iterable<Node> getSuperNodes() {
            return this.superElemIterator;
        }

        void addSubNodeInfo(MergeInfo subNodeInfo) {
            assert (subNodeInfo != null);
            if (this.subNodeInfos == null) {
                this.subNodeInfos = new ArrayList<MergeInfo>();
            }
            this.subNodeInfos.add(subNodeInfo);
        }

        protected List<MergeInfo> getSubNodeInfos() {
            if (this.subNodeInfos == null) {
                return Collections.EMPTY_LIST;
            }
            return this.subNodeInfos;
        }

        void createResultNode(MergeClassLoader mergeClassLoader) throws MergeException {
            if (this.nodeClasses == null) {
                try {
                    this.result = (Node)this.elem.getClass().newInstance();
                }
                catch (Exception e) {
                    throw new MergeException("Cannot merge ASTs", this.elem, e);
                }
            }
            try {
                Class<?> merged = mergeClassLoader.mergeNodeClasses(this.elem.astGetType(), this.nodeClasses);
                this.result = (Node)merged.newInstance();
            }
            catch (Exception e) {
                throw new MergeException("Cannot merge AST classes", this.elem, e);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class SuperElemIterator
        implements Iterable<Node>,
        Iterator<Node> {
            boolean modification;
            boolean superElemReturned;
            Iterator<Node> additionalSuperElemsIterator;

            private SuperElemIterator() {
            }

            @Override
            public Iterator<Node> iterator() {
                this.resetIterator();
                return this;
            }

            @Override
            public boolean hasNext() {
                if (this.modification) {
                    throw new ConcurrentModificationException();
                }
                if (this.superElemReturned) {
                    assert (MergeInfo.this.superElem != null);
                    if (this.additionalSuperElemsIterator == null) {
                        if (MergeInfo.this.additionalSuperElems == null) {
                            return false;
                        }
                        return MergeInfo.this.additionalSuperElems.size() > 0;
                    }
                    return this.additionalSuperElemsIterator.hasNext();
                }
                return MergeInfo.this.superElem != null;
            }

            @Override
            public Node next() {
                if (this.modification) {
                    throw new ConcurrentModificationException();
                }
                if (this.superElemReturned) {
                    assert (MergeInfo.this.superElem != null);
                    if (this.additionalSuperElemsIterator == null) {
                        if (MergeInfo.this.additionalSuperElems == null) {
                            throw new NoSuchElementException();
                        }
                        this.additionalSuperElemsIterator = MergeInfo.this.additionalSuperElems.iterator();
                    }
                    return this.additionalSuperElemsIterator.next();
                }
                if (MergeInfo.this.superElem == null) {
                    throw new NoSuchElementException();
                }
                this.superElemReturned = true;
                return MergeInfo.this.superElem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void resetIterator() {
                this.superElemReturned = false;
                this.additionalSuperElemsIterator = null;
                this.modification = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SubNodeArity {
        ONE,
        MANY,
        NONE;

    }
}

