/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.xml.DTDHandler;
import org.objectweb.fractal.adl.xml.XMLNode;
import org.objectweb.fractal.adl.xml.XMLNodeClassLoader;
import org.objectweb.fractal.adl.xml.XMLNodeFactory;
import org.xml.sax.SAXException;

public class XMLNodeFactoryImpl
implements XMLNodeFactory {
    protected Map<String, XMLNodeClassLoader> loaders = new HashMap<String, XMLNodeClassLoader>();
    public ClassLoader classLoader = this.getClass().getClassLoader();

    public void checkDTD(String systemId) throws SAXException {
        XMLNodeClassLoader loader = this.loaders.get(systemId);
        if (loader == null) {
            try {
                InputStream is;
                loader = new XMLNodeClassLoader(this.classLoader);
                if (systemId.startsWith("classpath://")) {
                    is = this.classLoader.getResourceAsStream(systemId.substring("classpath://".length()));
                    if (is == null) {
                        throw new SAXException("Unable to find DTD '" + systemId + "'");
                    }
                } else if (systemId.startsWith("file:")) {
                    is = new URL(systemId).openStream();
                } else {
                    throw new MalformedURLException("Unrecognized system identifier: " + systemId);
                }
                new DTDHandler().checkDTD(is, loader);
            }
            catch (MalformedURLException e) {
                throw new SAXException("Cannot find the DTD", e);
            }
            catch (IOException e) {
                throw new SAXException("Cannot read the DTD", e);
            }
            catch (ClassNotFoundException e) {
                throw new SAXException("Cannot check the DTD", e);
            }
            this.loaders.put(systemId, loader);
        }
    }

    public XMLNode newXMLNode(String systemId, String qualifiedName) throws SAXException {
        XMLNodeClassLoader loader = this.loaders.get(systemId);
        if (loader == null) {
            this.checkDTD(systemId);
            loader = this.loaders.get(systemId);
        }
        String xmlNodeClassName = loader.getASTClassName(qualifiedName);
        try {
            Class<?> loadClass = loader.loadClass(xmlNodeClassName);
            return (XMLNode)loadClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SAXException("The element <" + qualifiedName + "> can't be mapped to any AST node type. Check that you spell it correctly, or that the '" + xmlNodeClassName + "' exists, or that your DTD configuration [" + systemId + "] is correct", cnfe);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException("Internal error", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }
}

