/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import org.ow2.petals.launcher.configuration.Configuration;
import org.ow2.petals.launcher.exception.PetalsLauncherException;

public class PetalsClassLoader
extends URLClassLoader {
    protected static final String PETALS_KERNEL_JAR_REGEXP = "petals-kernel-(\\d+)(\\.(\\d+))?(\\.(\\d+))?(-.*)?\\.jar";

    public PetalsClassLoader(Configuration config) throws PetalsLauncherException {
        super(new URL[0], PetalsClassLoader.class.getClassLoader());
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(PetalsClassLoader.PETALS_KERNEL_JAR_REGEXP);
                }
            };
            for (File jar : config.getLibDirectory().listFiles(filter)) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new PetalsLauncherException(e);
        }
    }
}

