/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.config.RemoteConfiguration;
import org.ow2.petals.registry.api.config.TopologyLoader;
import org.ow2.petals.registry.api.exception.RegistryException;

public class PropertiesTopologyLoader
implements TopologyLoader {
    private static Log logger = LogFactory.getLog(PropertiesTopologyLoader.class);

    @Override
    public List<RemoteConfiguration> load(InputStream is) throws RegistryException {
        if (is == null) {
            throw new RegistryException("Can not load a topology from a null input stream");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage());
            throw new RegistryException("Can not load the topology file");
        }
        ArrayList<RemoteConfiguration> result = new ArrayList<RemoteConfiguration>();
        String hosts = props.getProperty("hosts");
        ArrayList<String> list = new ArrayList<String>();
        if (hosts != null && hosts.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(hosts, ",");
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        for (String host : list) {
            RemoteConfiguration configuration = new RemoteConfiguration(host);
            configuration.setMessageSenderClassName(props.getProperty(host + ".message.sender", "org.ow2.petals.registry.core.transport.cxf.CXFMessageSender"));
            configuration.setUri(props.getProperty(host + ".uri"));
            result.add(configuration);
        }
        return result;
    }
}

