/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.topology;

import java.io.File;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.petals.topology.TopologyException;
import org.ow2.petals.topology.generated.ObjectFactory;
import org.ow2.petals.topology.generated.Topology;
import org.xml.sax.SAXException;

public final class TopologyBuilder {
    public static final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String TOPOLOGY_XSD = "petalsTopology.xsd";
    private static TopologyException jaxbContextCreationEx;
    private static Unmarshaller unmarshaller;
    private static TopologyException unmarshCreationEx;
    private static Marshaller marshaller;
    private static TopologyException marshCreationEx;

    private TopologyBuilder() {
    }

    public static Topology createTopology(String xmlFileName) throws TopologyException {
        return TopologyBuilder.createTopology(new File(xmlFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Topology createTopology(File xmlFile) throws TopologyException {
        if (unmarshaller == null) {
            throw unmarshCreationEx;
        }
        try {
            JAXBElement root;
            Unmarshaller unmarshaller = TopologyBuilder.unmarshaller;
            synchronized (unmarshaller) {
                root = TopologyBuilder.unmarshaller.unmarshal((Source)new StreamSource(xmlFile), Topology.class);
            }
            return (Topology)root.getValue();
        }
        catch (JAXBException e) {
            throw new TopologyException("Failed to build topology", (Exception)((Object)e));
        }
    }

    public static synchronized void marshallTopologyFile(File xmlFile, Topology topology) throws TopologyException {
        if (marshaller == null) {
            throw marshCreationEx;
        }
        try {
            ObjectFactory jaxbObjectFactory = new ObjectFactory();
            JAXBElement<Topology> topologyElement = jaxbObjectFactory.createTopology(topology);
            marshaller.marshal(topologyElement, xmlFile);
        }
        catch (JAXBException ex) {
            throw new TopologyException("Failed to write local topology on disk", (Exception)((Object)ex));
        }
    }

    static {
        InputStream schemaInputStream = TopologyBuilder.class.getResourceAsStream("/petalsTopology.xsd");
        try {
            SchemaFactory factory = SchemaFactory.newInstance(NAMESPACE_XSD);
            Source[] schemas = new StreamSource[]{new StreamSource(schemaInputStream)};
            Schema schema = factory.newSchema(schemas);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Topology.class});
                try {
                    unmarshaller = jaxbContext.createUnmarshaller();
                    unmarshaller.setSchema(schema);
                }
                catch (JAXBException ex) {
                    unmarshCreationEx = new TopologyException("Failed to create the JAXB unmarshaller", (Exception)((Object)ex));
                }
                try {
                    marshaller = jaxbContext.createMarshaller();
                    marshaller.setSchema(schema);
                    marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                    marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                }
                catch (JAXBException ex) {
                    marshCreationEx = new TopologyException("Failed to create the JAXB marshaller", (Exception)((Object)ex));
                }
            }
            catch (JAXBException ex) {
                jaxbContextCreationEx = new TopologyException("Failed to create the JAXB context", (Exception)((Object)ex));
            }
        }
        catch (SAXException e) {
            TopologyException schemaCreationEx = new TopologyException("Failed to parse resource 'petalsTopology.xsd'", e);
            jaxbContextCreationEx = new TopologyException("Failed to create the JAXB context", schemaCreationEx);
            unmarshCreationEx = new TopologyException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshCreationEx = new TopologyException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

