/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.util;

import java.util.logging.Level;
import org.ow2.petals.kernel.api.log.Logger;

public class LoggingUtil
implements Logger {
    protected java.util.logging.Logger log;
    protected String name;

    public LoggingUtil(java.util.logging.Logger logger) {
        this(logger, "");
    }

    public LoggingUtil(java.util.logging.Logger logger, String loggerName) {
        this.log = logger;
        loggerName = loggerName != null && loggerName.trim().length() > 0 ? "[" + loggerName + "] " : "";
        this.name = loggerName;
    }

    @Override
    public void call() {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-CALL-" + LoggingUtil.classAndMethod());
        }
    }

    @Override
    public void call(Object msg) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-CALL-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    @Override
    public void start() {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-START-" + LoggingUtil.classAndMethod());
        }
    }

    @Override
    public void start(Object msg) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-START-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    @Override
    public void end() {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-END-" + LoggingUtil.classAndMethod());
        }
    }

    @Override
    public void end(Object msg) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-END-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + LoggingUtil.classAndMethod() + " " + message);
        }
    }

    @Override
    public void info(Object message) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.INFO, this.name + LoggingUtil.classAndMethod() + " " + message);
            } else {
                this.log.log(Level.INFO, this.name + message);
            }
        }
    }

    @Override
    public void info(Object message, Throwable error) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.INFO, this.name + LoggingUtil.classAndMethod() + " " + message, error);
            } else {
                this.log.log(Level.INFO, this.name + message, error);
            }
        }
    }

    @Override
    public void warning(Object message) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.log(Level.WARNING, this.name + message);
        }
    }

    @Override
    public void warning(Object message, Throwable throwable) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.log(Level.WARNING, this.name + message, throwable);
        }
    }

    @Override
    public void error(Object message) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.log(Level.SEVERE, this.name + message);
        }
    }

    @Override
    public void error(Object message, Throwable throwable) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.log(Level.SEVERE, this.name + message, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.FINEST);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.SEVERE);
    }

    private boolean isLevelEnabled(Level level) {
        return this.log != null && this.log.isLoggable(level);
    }

    private static String classAndMethod() {
        String result = null;
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        if (ste != null && ste.length > 2) {
            String className;
            int index;
            StackTraceElement element = ste[2];
            if (element.getClassName().endsWith(LoggingUtil.class.getName())) {
                element = ste[3];
            }
            if ((index = (className = element.getClassName()).lastIndexOf(".")) > -1) {
                className = className.substring(index + 1, className.length());
            }
            result = className + "." + element.getMethodName() + "()";
        }
        return result;
    }

    @Override
    public String getName() {
        return this.log.getName();
    }

    @Override
    public java.util.logging.Logger getLogger() {
        return this.log;
    }
}

