/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.annotations.jwsValImpl;

import java.util.Set;
import spoon.aval.Validator;
import spoon.aval.annotations.jwsVal.ValidWebServiceBean;
import spoon.aval.processing.ValidationPoint;
import spoon.processing.ProblemFixer;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ModifierKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidWebServiceBeanValidator
implements Validator<ValidWebServiceBean> {
    @Override
    public void check(ValidationPoint<ValidWebServiceBean> vp) {
        if (vp.getProgramElement() instanceof CtClass) {
            CtClass wsBean = (CtClass)vp.getProgramElement();
            boolean isOuter = wsBean.getParent(CtClass.class) == null;
            boolean isFinal = wsBean.hasModifier(ModifierKind.FINAL);
            boolean hasDefautlConstructor = this.hasDefaultConstructor(wsBean);
            if (!isOuter) {
                ValidationPoint.report(Severity.ERROR, (CtElement)wsBean, "A Web Service Bean should be an outer class", new ProblemFixer[0]);
            }
            if (isFinal) {
                ValidationPoint.report(Severity.ERROR, (CtElement)wsBean, "A Web Service Bean should not be a final class", new ProblemFixer[0]);
            }
            if (!hasDefautlConstructor) {
                ValidationPoint.report(Severity.ERROR, (CtElement)wsBean, "A Web Service Bean should declare a public default constructor", new ProblemFixer[0]);
            }
        }
    }

    private boolean hasDefaultConstructor(CtClass<?> wsBean) {
        Set constructors = wsBean.getConstructors();
        for (CtConstructor cons : constructors) {
            boolean hasParams;
            boolean isPublic = cons.hasModifier(ModifierKind.PUBLIC);
            boolean bl = hasParams = cons.getParameters().size() != 0;
            if (!isPublic || hasParams) continue;
            return true;
        }
        return false;
    }
}

