/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.processing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import spoon.aval.processing.APPoint;
import spoon.processing.AbstractProcessor;
import spoon.processing.Processor;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtStackScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessingMapProcessor
extends AbstractProcessor<CtAnnotationType<?>> {
    private List<CtPackage> framework;
    private List<APPoint> report;

    public void init() {
        super.init();
        this.framework = new ArrayList<CtPackage>();
        this.framework.addAll(this.getFactory().Package().getAll());
        this.framework.remove(this.getFactory().Package().get("org.hibernate.annotations"));
        this.framework.remove(this.getFactory().Package().get("org.hibernate.validator"));
        this.report = new ArrayList<APPoint>();
    }

    public void process(CtAnnotationType<?> element) {
        APPoint point = new APPoint();
        point.ap = element;
        point.apPosition = this.checkTypeUse(element);
        point.attribsPosition = new HashMap();
        List fields = element.getFields();
        for (CtField field : fields) {
            point.attribsPosition.put(field, this.checkAccess(field));
        }
        this.report.add(point);
    }

    private List<CtElement> checkAccess(final CtField<?> field) {
        boolean[] found = new boolean[1];
        final ArrayList<CtElement> users = new ArrayList<CtElement>();
        found[0] = false;
        for (CtPackage pack : this.framework) {
            new CtStackScanner(){

                public void scan(CtReference reference) {
                    CtExecutableReference ref;
                    if (reference instanceof CtExecutableReference && (ref = (CtExecutableReference)reference).getSimpleName().equals(field.getSimpleName()) && ref.getDeclaringType().equals(field.getDeclaringType().getReference()) && ((CtElement)this.elementStack.peek()).getParent(CtExecutable.class) != null) {
                        users.add((CtElement)this.elementStack.peek());
                    }
                    super.scan(reference);
                }
            }.scan((CtElement)pack);
        }
        return users;
    }

    private List<CtElement> checkTypeUse(final CtAnnotationType<?> element) {
        final ArrayList<CtElement> users = new ArrayList<CtElement>();
        for (CtPackage pack : this.framework) {
            new CtStackScanner(){

                public void scan(CtReference reference) {
                    CtTypeReference ref;
                    if (reference instanceof CtTypeReference && (ref = (CtTypeReference)reference).equals(element.getReference()) && ((CtElement)this.elementStack.peek()).getParent(CtExecutable.class) != null && !users.contains(this.elementStack.peek())) {
                        users.add((CtElement)this.elementStack.peek());
                    }
                    super.scan(reference);
                }
            }.scan((CtElement)pack);
        }
        return users;
    }

    public void processingDone() {
        super.processingDone();
        for (APPoint point : this.report) {
            point.ap.getFactory().getEnvironment().report((Processor)this, Severity.MESSAGE, (CtElement)point.ap, "Annotation " + point.ap.getSimpleName());
            for (CtElement p : point.apPosition) {
                p.getFactory().getEnvironment().report((Processor)this, Severity.MESSAGE, p, "is processed ");
            }
        }
    }
}

