/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.processing;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import spoon.aval.processing.APPoint;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.SourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportFrame
extends JFrame {
    private static final long serialVersionUID = -5118768893183502357L;
    JTree tree = new JTree();

    public ReportFrame(List<APPoint> r) {
        this.tree.setModel(new ReportModel(r));
        this.tree.setCellRenderer(new Renderer());
        JScrollPane jsp = new JScrollPane(this.tree);
        this.tree.setScrollsOnExpand(true);
        this.getContentPane().add(jsp);
        this.setSize(640, 480);
    }

    class Renderer
    implements TreeCellRenderer {
        JLabel lbl = new JLabel();

        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.lbl.setBackground(Color.green);
            } else {
                this.lbl.setBackground(Color.white);
            }
            if (value instanceof CtSimpleType) {
                CtSimpleType stV = (CtSimpleType)value;
                this.lbl.setText(stV.getSimpleName());
            } else if (value instanceof CtElement) {
                SourcePosition sp = ((CtElement)value).getPosition();
                this.lbl.setText(sp.getFile() + " : " + sp.getLine());
            } else if (value instanceof List) {
                this.lbl.setText("Report");
            } else {
                this.lbl.setText(value.toString());
            }
            return this.lbl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReportModel
    implements TreeModel {
        List<APPoint> rep;
        List<TreeModelListener> list;

        public ReportModel(List<APPoint> r) {
            this.rep = r;
            this.list = new ArrayList<TreeModelListener>();
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.list.add(l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof List) {
                return this.rep.get((int)index).ap;
            }
            for (APPoint point : this.rep) {
                if (!point.ap.equals(parent)) continue;
                return point.apPosition.get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof List) {
                return this.rep.size();
            }
            for (APPoint point : this.rep) {
                if (!point.ap.equals(parent)) continue;
                return point.apPosition.size();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            for (APPoint point : this.rep) {
                point.ap.equals(parent);
            }
            return 0;
        }

        @Override
        public Object getRoot() {
            return this.rep;
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof SourcePosition;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.list.remove(l);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

