/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.support.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import spoon.aval.Validator;
import spoon.aval.annotation.value.Matches;
import spoon.aval.processing.ValidationPoint;
import spoon.processing.ProblemFixer;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtFieldReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchesValidator
implements Validator<Matches> {
    @Override
    public void check(ValidationPoint<Matches> vp) {
        String regExp = vp.getValAnnotation().value();
        String attribName = ((CtFieldReference)vp.getDslElement()).getSimpleName();
        String target = (String)vp.getDslAnnotation().getElementValue(attribName);
        if (target == null) {
            return;
        }
        try {
            Pattern p = Pattern.compile(regExp);
            Matcher m = p.matcher(target);
            boolean matches = m.matches();
            if (!matches) {
                CtAnnotation dslAnnotation = vp.getDslAnnotation();
                String message = vp.getValAnnotation().message().replace("?value", target).replace("?regExp", regExp);
                ValidationPoint.report(Severity.ERROR, (CtElement)dslAnnotation, message, new ProblemFixer[0]);
            }
        }
        catch (PatternSyntaxException pe) {
            CtElement dslElement = vp.getDslElement().getDeclaration();
            if (dslElement == null) {
                throw pe;
            }
            String message = "The expression '" + regExp + "' is not a valid Java Regular expression!";
            ValidationPoint.report(vp.getValAnnotation().severity(), dslElement, message, vp.fixerFactory(vp.getValAnnotation().fixers()));
        }
    }
}

