/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.manager;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.Information;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.ReceptionException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.AbstractLifeCycle;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.util.Assert;

public class GenericIncomingManagerImpl
implements IncomingManager {
    protected AbstractLifeCycle lifeCycle;
    protected LocalRegistry localRegistry;
    protected String name;
    protected boolean receive = true;
    private final Log log = LogFactory.getLog(GenericIncomingManagerImpl.class);

    public GenericIncomingManagerImpl() {
        this.lifeCycle = new AbstractLifeCycle(){

            protected void doInit(Context context) throws LifeCycleException {
                if (GenericIncomingManagerImpl.this.getLocalRegistry() == null) {
                    throw new LifeCycleException("Local registry has not been set");
                }
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalRegistry getLocalRegistry() {
        return this.localRegistry;
    }

    public void setLocalRegistry(LocalRegistry localRegistry) throws LifeCycleException {
        if (!this.isNotInitialized()) {
            throw new LifeCycleException("Can not set the local registry in the state " + this.getState());
        }
        this.localRegistry = localRegistry;
    }

    public void pause() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Suspending message reception");
        }
        this.receive = false;
    }

    public void resume() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Resuming message reception");
        }
        this.receive = true;
    }

    protected void checkReceive() throws ReceptionException {
        if (!this.receive) {
            throw new ReceptionException("Receive data is not started or suspended");
        }
    }

    protected void checkPath(String path) throws RegistryException {
        if (path == null) {
            throw new RegistryException("Path is null");
        }
    }

    protected void checkSource(Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Check that the operation information is OK");
        }
        if (information == null) {
            throw new RegistryException("No information means no access!!!");
        }
        if (information.getSender().equals(this.localRegistry.getName())) {
            throw new RegistryException("Can not receive a locally created resource");
        }
    }

    public final Resource get(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get the resource " + path));
        }
        this.checkSource(information);
        this.checkPath(path);
        this.checkReceive();
        return this.doGet(path);
    }

    protected Resource doGet(String path) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Got a get call");
        }
        if (path == null) {
            throw new RegistryException("Can not get a resource with key = null");
        }
        return this.getLocalRegistry().getRepository().get(path, false);
    }

    public final boolean put(String path, Resource resource, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put the resource " + path));
        }
        this.checkSource(information);
        this.checkPath(path);
        this.checkReceive();
        return this.doPut(path, resource);
    }

    protected boolean doPut(String key, Resource resource) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put the resource " + resource));
        }
        if (resource == null) {
            throw new RegistryException("Can not put a null resource");
        }
        return this.getLocalRegistry().getRepository().put(key, resource, false);
    }

    public final boolean delete(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Delete the resource " + path));
        }
        this.checkSource(information);
        this.checkPath(path);
        this.checkReceive();
        return this.doDelete(path);
    }

    protected boolean doDelete(String key) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Got a delete request");
        }
        if (key == null) {
            throw new RegistryException("Can not delete a resource with key = null");
        }
        this.getLocalRegistry().getRepository().delete(key, false);
        return true;
    }

    public final List<Resource> getAll(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get all the resources from " + path));
        }
        this.checkSource(information);
        this.checkPath(path);
        this.checkReceive();
        return this.doGetAll(path);
    }

    protected List<Resource> doGetAll(String path) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Got a getall call");
        }
        if (path == null) {
            throw new RegistryException("Can not get a resource with key = null");
        }
        return this.getLocalRegistry().getRepository().getAll(path, false);
    }

    public final List<Resource> query(Query query, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Query with " + query));
        }
        this.checkSource(information);
        this.checkReceive();
        return this.doQuery(query);
    }

    protected List<Resource> doQuery(Query query) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got a query call " + query));
        }
        if (query == null) {
            throw new RegistryException("Can not query with a null query");
        }
        return this.getLocalRegistry().getRepository().query(query, false);
    }

    protected void setLifeCycle(AbstractLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public LifeCycle.STATE getState() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.getState();
    }

    public void init(Context context) throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.init(context);
    }

    public boolean isInitialized() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isInitialized();
    }

    public boolean isNotInitialized() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isNotInitialized();
    }

    public boolean isRunning() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isRunning();
    }

    public boolean isStarted() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isStarted();
    }

    public boolean isStopped() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isStopped();
    }

    public void start() throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.start();
    }

    public void stop() throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.stop();
    }
}

