/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.HandlerFactory;

public class TestHandler
extends TestCase {
    public static final String[] SETTER_METHODS = new String[]{"setHandlerFactoryClassName"};
    protected HandlerFactory hf = null;
    private Handler hc = null;
    static /* synthetic */ Class class$org$objectweb$util$monolog$TestHandler;

    public TestHandler() {
        super("");
    }

    public void setHandlerFactoryClassName(String lfcn) {
        try {
            this.hf = (HandlerFactory)Class.forName(lfcn).newInstance();
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("The specified class is not a Handler factory: " + lfcn);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Handler factory class is not availlable: " + lfcn);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Syntax error !");
            System.out.println("java TestHandler <handler factory class name>");
            System.exit(12);
        }
        Object[] params = new Object[]{args[0]};
        try {
            TestSuite suite = new TestSuite(class$org$objectweb$util$monolog$TestHandler == null ? (class$org$objectweb$util$monolog$TestHandler = TestHandler.class$("org.objectweb.util.monolog.TestHandler")) : class$org$objectweb$util$monolog$TestHandler, SETTER_METHODS, params);
            TestRunner.run((Test)suite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TestSuite getTestSuite(String lfcn) {
        Object[] params = new Object[]{lfcn};
        try {
            return new TestSuite(class$org$objectweb$util$monolog$TestHandler == null ? (class$org$objectweb$util$monolog$TestHandler = TestHandler.class$("org.objectweb.util.monolog.TestHandler")) : class$org$objectweb$util$monolog$TestHandler, SETTER_METHODS, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void testConsoleHandlerDef() {
        this.testHandlerDef("console");
    }

    public void testFileHandlerDef() {
        this.testHandlerDef("file");
    }

    public void testRollingFileHandlerDef() {
        this.testHandlerDef("rollingfile");
    }

    protected void testHandlerDef(String handlerType) {
        this.hc = this.hf.createHandler("MyHandler", handlerType);
        this.hc.setAttribute("toto_key", "toto_value");
        this.hc.setAttribute("titi.key", "titi.value");
        TestHandler.assertEquals((String)"assigns property", (Object)"toto_value", (Object)this.hc.getAttribute("toto_key"));
        TestHandler.assertEquals((String)"assigns property with dot", (Object)"titi.value", (Object)this.hc.getAttribute("titi.key"));
        TestHandler.assertEquals((String)"assigns a handler name", (Object)"MyHandler", (Object)this.hc.getName());
        TestHandler.assertEquals((String)"Handler not correctly registered into MonologConf", (Object)this.hc, (Object)this.hf.getHandler("MyHandler"));
        TestHandler.assertEquals((String)"Handler not correctly registered into MonologConf (time 2)", (Object)this.hc, (Object)this.hf.getHandler("MyHandler"));
        this.hc = this.hf.getHandler("MyHandler");
        TestHandler.assertEquals((String)"assigns property after getHandlerConf(String)", (Object)"toto_value", (Object)this.hc.getAttribute("toto_key"));
        TestHandler.assertEquals((String)"assigns property with dot after getHandlerConf(String)", (Object)"titi.value", (Object)this.hc.getAttribute("titi.key"));
        TestHandler.assertEquals((String)"assigns a handler name after getHandlerConf(String)", (Object)"MyHandler", (Object)this.hc.getName());
        TestHandler.assertEquals((String)"getHandler() with one HandlerConf", (int)1, (int)this.hf.getHandlers().length);
        this.hf.removeHandler("MyHandler");
        TestHandler.assertEquals((String)"removeHandler with one HandlerConf", (int)0, (int)this.hf.getHandlers().length);
    }

    public void testgetConsoleHandlerByName() {
        this.testgetHandlerByName("console");
    }

    public void testgetFileHandlerByName() {
        this.testgetHandlerByName("file");
    }

    public void testgetRollingFileHandlerByName() {
        this.testgetHandlerByName("rollingfile");
    }

    protected void testgetHandlerByName(String handlerType) {
        int i;
        int iternumber = 20;
        for (i = 0; i < iternumber; ++i) {
            this.hc = this.hf.createHandler("MyHandler" + i, handlerType);
            this.hc.setAttribute("toto_key" + i, "toto_value" + i);
            this.hc.setAttribute("titi.key" + i, "titi.value" + i);
        }
        for (i = 0; i < iternumber; ++i) {
            String name = "MyHandler" + i;
            this.hc = this.hf.getHandler(name);
            TestHandler.assertNotNull((String)("fetch " + name), (Object)this.hc);
            TestHandler.assertEquals((String)("name value by fetch " + name), (Object)name, (Object)this.hc.getName());
            TestHandler.assertEquals((String)("assigns property by fetch " + name), (Object)("toto_value" + i), (Object)this.hc.getAttribute("toto_key" + i));
            TestHandler.assertEquals((String)("assigns property with dot by fetch " + name), (Object)("titi.value" + i), (Object)this.hc.getAttribute("titi.key" + i));
        }
    }

    public void testGetAllHandlerConsole() {
        this.testGetAllHandler("console");
    }

    public void testGetAllHandlerFile() {
        this.testGetAllHandler("file");
    }

    public void testGetAllHandlerRollingFile() {
        this.testGetAllHandler("rollingfile");
    }

    protected void testGetAllHandler(String handlerType) {
        int iternumber = 20;
        for (int i = 0; i < iternumber; ++i) {
            this.hc = this.hf.createHandler("MyHandler" + i, handlerType);
            this.hc.setAttribute("toto_key" + i, "toto_value" + i);
            this.hc.setAttribute("titi.key" + i, "titi.value" + i);
        }
        Handler[] hcs = this.hf.getHandlers();
        TestHandler.assertEquals((String)("getHandler with " + iternumber + " HandlerConf"), (int)iternumber, (int)hcs.length);
        Handler[] hcs2 = new Handler[hcs.length];
        for (int i = 0; i < hcs.length; ++i) {
            this.hc = hcs[i];
            int j = Integer.parseInt(this.hc.getName().substring(9, this.hc.getName().length()));
            TestHandler.assertNull((String)"Duplicate HandlerConf", (Object)hcs2[j]);
            hcs2[j] = this.hc;
            String name = "MyHandler" + j;
            TestHandler.assertNotNull((String)("fetch " + name), (Object)this.hc);
            TestHandler.assertEquals((String)("name value by fetch " + name), (Object)name, (Object)this.hc.getName());
            TestHandler.assertEquals((String)("assigns property by fetch " + name), (Object)("toto_value" + j), (Object)this.hc.getAttribute("toto_key" + j));
            TestHandler.assertEquals((String)("assigns property with dot by fetch " + name), (Object)("titi.value" + j), (Object)this.hc.getAttribute("titi.key" + j));
        }
    }

    public void testRemoveConsoleHandler() {
        this.testRemoveHandler("console");
    }

    public void testRemoveFileHandler() {
        this.testRemoveHandler("file");
    }

    public void testRemoveRollingFileHandler() {
        this.testRemoveHandler("rollingfile");
    }

    public void testRemoveHandler(String handlerType) {
        int iternumber = 20;
        for (int i = 0; i < iternumber; ++i) {
            this.hc = this.hf.createHandler("MyHandler" + i, handlerType);
            this.hc.setAttribute("toto_key" + i, "toto_value" + i);
            this.hc.setAttribute("titi.key" + i, "titi.value" + i);
        }
        Handler[] hcs = this.hf.getHandlers();
        for (int i = 0; i < hcs.length; ++i) {
            String name = "MyHandler" + i;
            this.hf.removeHandler(name);
            Assert.assertNull((String)("Remove " + name), (Object)this.hf.getHandler(name));
        }
    }

    protected void testgetHandlerByName() {
        int i;
        int iternumber = 20;
        for (i = 0; i < iternumber; ++i) {
            this.hc = i < iternumber / 3 ? this.hf.createHandler("MyHandler" + i, "console") : (i < 2 * iternumber / 3 ? this.hf.createHandler("MyHandler" + i, "file") : this.hf.createHandler("MyHandler" + i, "rollingfile"));
            this.hc.setAttribute("toto_key" + i, "toto_value" + i);
            this.hc.setAttribute("titi.key" + i, "titi.value" + i);
        }
        for (i = 0; i < iternumber; ++i) {
            String name = "MyHandler" + i;
            this.hc = this.hf.getHandler(name);
            TestHandler.assertNotNull((String)("fetch " + name), (Object)this.hc);
            TestHandler.assertEquals((String)("name value by fetch " + name), (Object)name, (Object)this.hc.getName());
            TestHandler.assertEquals((String)("assigns property by fetch " + name), (Object)("toto_value" + i), (Object)this.hc.getAttribute("toto_key" + i));
            TestHandler.assertEquals((String)("assigns property with dot by fetch " + name), (Object)("titi.value" + i), (Object)this.hc.getAttribute("titi.key" + i));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

