/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.javaLog.GenericHandler;
import org.objectweb.util.monolog.wrapper.javaLog.LevelImpl;

public class Logger
extends java.util.logging.Logger
implements TopicalLogger {
    boolean enabled = true;
    protected java.util.logging.Logger inner = null;

    protected Logger(java.util.logging.Logger inner) {
        super(inner.getName(), inner.getResourceBundleName());
        this.inner = inner;
    }

    protected Logger(String name, String resName) {
        super(name, resName);
        this.inner = this;
    }

    public void addHandler(java.util.logging.Handler handler) {
        GenericHandler gh = null;
        gh = handler instanceof GenericHandler ? (GenericHandler)handler : new GenericHandler(handler.toString(), handler);
        if (this.inner == this) {
            super.addHandler(gh);
        } else {
            this.inner.addHandler(gh);
        }
    }

    public void setName(String name) {
    }

    public String getType() {
        return "logger";
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Object setAttribute(String name, Object value) {
        return null;
    }

    public void addHandler(Handler h) throws Exception {
        this.inner.addHandler((GenericHandler)h);
        if (AbstractFactory.debug) {
            AbstractFactory.debug("logger(" + this.getName() + ").addHandler: " + h.getName() + "=>" + this.inner.getHandlers().length);
        }
    }

    public Handler getHandler(String hn) {
        java.util.logging.Handler[] hs = this.inner.getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            if (!(hs[i] instanceof Handler) || !hn.equals(((Handler)((Object)hs[i])).getName())) continue;
            return (Handler)((Object)hs[i]);
        }
        return null;
    }

    public synchronized Handler[] getHandler() {
        java.util.logging.Handler[] os = this.inner.getHandlers();
        Handler[] hs = new Handler[os.length];
        for (int i = 0; i < os.length; ++i) {
            hs[i] = os[i] instanceof Handler ? (Handler)((Object)os[i]) : new GenericHandler("", os[i]);
        }
        return hs;
    }

    public void removeHandler(Handler h) throws Exception {
        if (this.inner == this) {
            super.removeHandler((GenericHandler)h);
        } else {
            this.inner.removeHandler((GenericHandler)h);
        }
    }

    public void removeAllHandlers() throws Exception {
        java.util.logging.Handler[] hs = this.inner.getHandlers();
        if (AbstractFactory.debug) {
            AbstractFactory.debug("logger(" + this.getName() + ").removeAllHandlers(): before: " + hs.length);
        }
        for (int i = 0; i < hs.length; ++i) {
            if (this.inner == this) {
                super.removeHandler(hs[i]);
                continue;
            }
            this.inner.removeHandler(hs[i]);
        }
        if (AbstractFactory.debug) {
            AbstractFactory.debug("logger(" + this.getName() + ").removeAllHandlers(): before: " + this.inner.getHandlers().length);
        }
    }

    public void setAdditivity(boolean a) {
        this.inner.setUseParentHandlers(a);
    }

    public boolean getAdditivity() {
        return this.inner.getUseParentHandlers();
    }

    public void addTopic(String topic) throws Exception {
    }

    public String[] getTopic() {
        return new String[]{this.inner.getName()};
    }

    public Enumeration getTopics() {
        return null;
    }

    public void removeTopic(String topic) throws Exception {
    }

    public void setIntLevel(int level) {
        this.inner.setLevel(LevelImpl.int2Level(level));
    }

    public void setLevel(Level l) {
        this.inner.setLevel(LevelImpl.convertLevel(l));
    }

    public int getCurrentIntLevel() {
        java.util.logging.Level l = this.getLevel();
        return l == null ? BasicLevel.INHERIT : l.intValue();
    }

    public Level getCurrentLevel() {
        return LevelImpl.getLevel(this.getCurrentIntLevel());
    }

    public boolean isLoggable(int l) {
        return this.enabled && super.isLoggable(LevelImpl.int2Level(l));
    }

    public boolean isLoggable(Level l) {
        return this.enabled && super.isLoggable(LevelImpl.convertLevel(l));
    }

    public boolean isOn() {
        return this.enabled;
    }

    public void log(int l, Object o) {
        this.inner.log(LevelImpl.int2Level(l), o == null ? "null" : o.toString());
    }

    public void log(Level l, Object o) {
        this.inner.log(LevelImpl.convertLevel(l), o == null ? "null" : o.toString());
    }

    public void log(int l, Object o, Throwable t) {
        this.inner.log(LevelImpl.int2Level(l), o == null ? "null" : o.toString(), t);
    }

    public void log(Level l, Object o, Throwable t) {
        this.inner.log(LevelImpl.convertLevel(l), o == null ? "null" : o.toString(), t);
    }

    public void log(int level, Object o, Object location, Object method) {
        this.inner.logp(LevelImpl.int2Level(level), location == null ? "null" : location.toString(), method == null ? "null" : method.toString(), o == null ? "null" : o.toString());
    }

    public void log(Level l, Object o, Object location, Object method) {
        this.inner.logp(LevelImpl.convertLevel(l), location == null ? "null" : location.toString(), method == null ? "null" : method.toString(), o == null ? "null" : o.toString());
    }

    public void log(int level, Object o, Throwable t, Object location, Object method) {
        this.inner.logp(LevelImpl.int2Level(level), location == null ? "null" : location.toString(), method == null ? "null" : method.toString(), o == null ? "null" : o.toString(), t);
    }

    public void log(Level l, Object o, Throwable t, Object location, Object method) {
        this.inner.logp(LevelImpl.convertLevel(l), location == null ? "null" : location.toString(), method == null ? "null" : method.toString(), o == null ? "null" : o.toString(), t);
    }

    public void turnOn() {
        this.enabled = true;
    }

    public void turnOff() {
        this.enabled = false;
    }
}

