/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;
import org.objectweb.util.monolog.wrapper.log4j.PatternConverter;

public class FileHandler
extends FileAppender
implements Handler {
    protected HashMap prop = null;

    public FileHandler() {
    }

    public FileHandler(String name) {
        this.setName(name);
        this.prop = new HashMap();
    }

    public Map getAttributes() {
        return this.prop;
    }

    public void setAttributes(Map attributes) {
        this.prop.clear();
        this.prop.putAll(attributes);
    }

    public String getType() {
        return "file";
    }

    public String[] getAttributeNames() {
        return this.prop.keySet().toArray(new String[0]);
    }

    public Object getAttribute(String key) {
        return this.prop.get(key);
    }

    public Object setAttribute(String key, Object value) {
        if (this.prop == null) {
            this.prop = new HashMap();
        }
        if (!key.equalsIgnoreCase("activation")) {
            return this.prop.put(key, value);
        }
        MonologFactory mf = (MonologFactory)value;
        String output = (String)this.prop.get("output");
        String append = (String)this.prop.get("appendMode");
        this.fileAppend = append != null && append.length() > 0 ? Boolean.getBoolean(append) : true;
        try {
            this.setFile(output, this.fileAppend, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            // empty catch block
        }
        String pattern = (String)this.prop.get("pattern");
        this.setLayout((Layout)new PatternLayout(PatternConverter.monolog2log4j(pattern)));
        String level = (String)this.prop.get("level");
        if (level != null && level.length() > 0) {
            int levelVal = LevelImpl.evaluate(level, mf);
            this.setThreshold(Priority.toPriority((int)levelVal));
        }
        return null;
    }
}

