/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.jmx.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import javax.management.monitor.GaugeMonitor;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.StringMonitor;
import org.objectweb.fractal.jmx.agent.AgentMonitorMBean;

public class AgentContext {
    private ObjectName[] _itfPatterns = new ObjectName[0];
    private ObjectName[] _monitorPatterns = new ObjectName[0];
    private AgentMonitorMBean[] _monitors = new AgentMonitorMBean[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public AgentMonitorMBean[] getMonitors() {
        return this._monitors;
    }

    public boolean matchItfPatterns(ObjectName oName) {
        return this.matchPatterns(this._itfPatterns, oName);
    }

    public boolean matchMonitorPatterns(ObjectName oName) {
        return this.matchPatterns(this._monitorPatterns, oName);
    }

    public void reset(String fc, String str, String counter, String gauge) throws JMException {
        this.cleanMonitors(this._monitors);
        this.set(fc, str, counter, gauge);
    }

    private void cleanMonitors(MonitorMBean[] monitors) {
        for (int i = 0; i < monitors.length; ++i) {
            monitors[i].stop();
            ObjectName[] onames = monitors[i].getObservedObjects();
            for (int j = 0; j < onames.length; ++j) {
                monitors[i].removeObservedObject(onames[j]);
            }
        }
    }

    private void set(String fc, String str, String counter, String gauge) throws JMException {
        AgentMonitorMBean[] stringMonitors = this.createStringMonitors(str);
        AgentMonitorMBean[] counterMonitors = this.createCounterMonitors(counter);
        AgentMonitorMBean[] gaugeMonitors = this.createGaugeMonitors(gauge);
        ArrayList<Object> l = new ArrayList<AgentMonitorMBean>(Arrays.asList(stringMonitors));
        l.addAll(Arrays.asList(counterMonitors));
        l.addAll(Arrays.asList(gaugeMonitors));
        this._monitors = l.toArray(new AgentMonitorMBean[0]);
        this._itfPatterns = this.createItfPatterns(fc);
        l = new ArrayList<ObjectName>(Arrays.asList(this.getMonitorPatterns(this._monitors)));
        this._monitorPatterns = l.toArray(new ObjectName[0]);
    }

    private ObjectName[] createItfPatterns(String str) throws MalformedObjectNameException {
        String[] strTab = this.split(str, ";");
        ObjectName[] oNames = new ObjectName[strTab.length];
        for (int i = 0; i < strTab.length; ++i) {
            try {
                oNames[i] = new ObjectName(strTab[i]);
                continue;
            }
            catch (MalformedObjectNameException e) {
                throw new MalformedObjectNameException("pattern \"" + strTab[i] + "\" is an invalid string representation of JMX object name");
            }
        }
        return oNames;
    }

    private boolean matchPatterns(ObjectName[] patterns, ObjectName oName) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].apply(oName)) continue;
            return true;
        }
        return false;
    }

    private ObjectName[] getMonitorPatterns(AgentMonitorMBean[] monitors) {
        ObjectName[] oNames = new ObjectName[monitors.length];
        for (int i = 0; i < oNames.length; ++i) {
            oNames[i] = monitors[i].getPattern();
        }
        return oNames;
    }

    private AgentMonitorMBean[] createStringMonitors(String str) throws MalformedObjectNameException {
        String[] strTab = this.split(str, ";");
        AgentMonitorMBean[] gauges = new MyStringMonitor[strTab.length];
        for (int i = 0; i < strTab.length; ++i) {
            try {
                ObjectName oName = new ObjectName(strTab[i]);
                Hashtable<String, String> h = oName.getKeyPropertyList();
                gauges[i] = new MyStringMonitor(i + 1);
                ((Monitor)((Object)gauges[i])).setObservedAttribute((String)this.remove(h, "observedAttribute"));
                ((Monitor)((Object)gauges[i])).setGranularityPeriod(Long.parseLong((String)this.remove(h, "granularityPeriod")));
                ((StringMonitor)((Object)gauges[i])).setStringToCompare((String)this.remove(h, "stringToCompare"));
                ((StringMonitor)((Object)gauges[i])).setNotifyDiffer(Boolean.valueOf((String)this.remove(h, "notifyDiffer")));
                ((StringMonitor)((Object)gauges[i])).setNotifyMatch(Boolean.valueOf((String)this.remove(h, "notifyMatch")));
                if (oName.isPropertyPattern()) {
                    ((MyStringMonitor)gauges[i]).setPattern(new ObjectName(oName.getDomain() + ":" + this.asString(h) + ",*"));
                    continue;
                }
                ((MyStringMonitor)gauges[i]).setPattern(new ObjectName(oName.getDomain(), h));
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("String monitor \"" + strTab[i] + "\" is invalid. " + e.toString() + ". " + "\nSyntax [domainName]:observedAttribute=value,granularityPeriod=value,stringToCompare=value,notifyDiffer=value,notifyMatch=value[,otherProperty=value]*");
            }
        }
        return gauges;
    }

    private AgentMonitorMBean[] createCounterMonitors(String str) throws MalformedObjectNameException {
        String[] strTab = this.split(str, ";");
        AgentMonitorMBean[] counters = new MyCounterMonitor[strTab.length * 4];
        for (int i = 0; i < strTab.length; ++i) {
            try {
                ObjectName oName = new ObjectName(strTab[i]);
                Hashtable<String, String> h = oName.getKeyPropertyList();
                int j = i * 4;
                counters[j] = new MyCounterMonitor(i + 1, class$java$lang$Long == null ? AgentContext.class$("java.lang.Long") : class$java$lang$Long);
                ((Monitor)((Object)counters[j])).setObservedAttribute((String)this.remove(h, "observedAttribute"));
                ((Monitor)((Object)counters[j])).setGranularityPeriod(Long.parseLong((String)this.remove(h, "granularityPeriod")));
                ((CounterMonitor)((Object)counters[j])).setInitThreshold(Long.valueOf((String)this.remove(h, "initThreshold")));
                ((CounterMonitor)((Object)counters[j])).setNotify(true);
                ((CounterMonitor)((Object)counters[j])).setModulus(Long.valueOf((String)this.remove(h, "modulus")));
                ((CounterMonitor)((Object)counters[j])).setOffset(Long.valueOf((String)this.remove(h, "offset")));
                ((CounterMonitor)((Object)counters[j])).setDifferenceMode(Boolean.valueOf((String)this.remove(h, "differenceMode")));
                if (oName.isPropertyPattern()) {
                    ((MyCounterMonitor)counters[j]).setPattern(new ObjectName(oName.getDomain() + ":" + this.asString(h) + ",*"));
                } else {
                    ((MyCounterMonitor)counters[j]).setPattern(new ObjectName(oName.getDomain(), h));
                }
                counters[j + 1] = new MyCounterMonitor((MyCounterMonitor)counters[j], class$java$lang$Integer == null ? AgentContext.class$("java.lang.Integer") : class$java$lang$Integer);
                counters[j + 2] = new MyCounterMonitor((MyCounterMonitor)counters[j], class$java$lang$Short == null ? AgentContext.class$("java.lang.Short") : class$java$lang$Short);
                counters[j + 3] = new MyCounterMonitor((MyCounterMonitor)counters[j], class$java$lang$Byte == null ? AgentContext.class$("java.lang.Byte") : class$java$lang$Byte);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Counter monitor \"" + strTab[i] + "\" is invalid. " + e.toString() + ". " + "\nSyntax [domainName]:observedAttribute=value,granularityPeriod=value,initThreshold=value,modulus=value,offset=value,differenceMode=value[,otherProperty=value]*");
            }
        }
        return counters;
    }

    private AgentMonitorMBean[] createGaugeMonitors(String str) throws MalformedObjectNameException {
        String[] strTab = this.split(str, ";");
        AgentMonitorMBean[] gauges = new MyGaugeMonitor[strTab.length * 6];
        for (int i = 0; i < strTab.length; ++i) {
            try {
                ObjectName oName = new ObjectName(strTab[i]);
                Hashtable<String, String> h = oName.getKeyPropertyList();
                int j = i * 4;
                gauges[j] = new MyGaugeMonitor(i + 1, class$java$lang$Double == null ? AgentContext.class$("java.lang.Double") : class$java$lang$Double);
                ((Monitor)((Object)gauges[j])).setObservedAttribute((String)this.remove(h, "observedAttribute"));
                ((Monitor)((Object)gauges[j])).setGranularityPeriod(Long.parseLong((String)this.remove(h, "granularityPeriod")));
                ((GaugeMonitor)((Object)gauges[j])).setNotifyLow(true);
                ((GaugeMonitor)((Object)gauges[j])).setNotifyHigh(true);
                ((GaugeMonitor)((Object)gauges[j])).setThresholds(Double.valueOf((String)this.remove(h, "highThreshold")), Double.valueOf((String)this.remove(h, "lowThreshold")));
                ((GaugeMonitor)((Object)gauges[j])).setDifferenceMode(Boolean.valueOf((String)this.remove(h, "differenceMode")));
                if (oName.isPropertyPattern()) {
                    ((MyGaugeMonitor)gauges[j]).setPattern(new ObjectName(oName.getDomain() + ":" + this.asString(h) + ",*"));
                } else {
                    ((MyGaugeMonitor)gauges[j]).setPattern(new ObjectName(oName.getDomain(), h));
                }
                gauges[j + 1] = new MyGaugeMonitor((MyGaugeMonitor)gauges[j], class$java$lang$Float == null ? AgentContext.class$("java.lang.Float") : class$java$lang$Float);
                gauges[j + 2] = new MyGaugeMonitor((MyGaugeMonitor)gauges[j], class$java$lang$Long == null ? AgentContext.class$("java.lang.Long") : class$java$lang$Long);
                gauges[j + 3] = new MyGaugeMonitor((MyGaugeMonitor)gauges[j], class$java$lang$Integer == null ? AgentContext.class$("java.lang.Integer") : class$java$lang$Integer);
                gauges[j + 4] = new MyGaugeMonitor((MyGaugeMonitor)gauges[j], class$java$lang$Short == null ? AgentContext.class$("java.lang.Short") : class$java$lang$Short);
                gauges[j + 5] = new MyGaugeMonitor((MyGaugeMonitor)gauges[j], class$java$lang$Byte == null ? AgentContext.class$("java.lang.Byte") : class$java$lang$Byte);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Gauge monitor \"" + strTab[i] + "\" is invalid. " + e.toString() + ". " + "\nSyntax [domainName]:observedAttribute=value,granularityPeriod=value,lowThreshold=value,highThreshold=value,differenceMode=value[,otherProperty=value]*");
            }
        }
        return gauges;
    }

    private String[] split(String str, String regex) {
        if (str == null || str.matches(" *")) {
            return new String[0];
        }
        return str.split(regex);
    }

    private Object remove(Hashtable h, String key) throws Exception {
        if (h.containsKey(key)) {
            return h.remove(key);
        }
        throw new Exception("property \"" + key + "\" is missing");
    }

    private String asString(Hashtable h) {
        String str = "";
        Iterator i = h.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            str = str + e.getKey() + "=" + e.getValue();
            if (!i.hasNext()) continue;
            str = str + ",";
        }
        return str;
    }

    class MyGaugeMonitor
    extends GaugeMonitor
    implements AgentMonitorMBean {
        private ObjectName _pattern;
        private int _i;
        private Class _attType;

        MyGaugeMonitor(int i, Class attType) throws JMException {
            this._pattern = new ObjectName("*:*");
            this._i = i;
            this._attType = attType;
        }

        MyGaugeMonitor(MyGaugeMonitor g, Class attType) {
            this._pattern = g.getPattern();
            this._i = g._i;
            this._attType = attType;
            this.setObservedAttribute(g.getObservedAttribute());
            this.setGranularityPeriod(g.getGranularityPeriod());
            this.setDifferenceMode(g.getDifferenceMode());
            this.setNotifyLow(g.getNotifyLow());
            this.setNotifyHigh(g.getNotifyHigh());
            Number high = g.getHighThreshold();
            Number low = g.getLowThreshold();
            if (attType.equals(class$java$lang$Double == null ? (class$java$lang$Double = AgentContext.class$("java.lang.Double")) : class$java$lang$Double)) {
                this.setThresholds(new Double(high.doubleValue()), new Double(low.doubleValue()));
            } else if (attType.equals(class$java$lang$Float == null ? (class$java$lang$Float = AgentContext.class$("java.lang.Float")) : class$java$lang$Float)) {
                this.setThresholds(new Float(high.floatValue()), new Float(low.floatValue()));
            } else if (attType.equals(class$java$lang$Long == null ? (class$java$lang$Long = AgentContext.class$("java.lang.Long")) : class$java$lang$Long)) {
                this.setThresholds(new Long(high.longValue()), new Long(low.longValue()));
            } else if (attType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = AgentContext.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                this.setThresholds(new Integer(high.intValue()), new Integer(low.intValue()));
            } else if (attType.equals(class$java$lang$Short == null ? (class$java$lang$Short = AgentContext.class$("java.lang.Short")) : class$java$lang$Short)) {
                this.setThresholds(new Short(high.shortValue()), new Short(low.shortValue()));
            } else if (attType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = AgentContext.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                this.setThresholds(new Byte(high.byteValue()), new Byte(low.byteValue()));
            } else {
                throw new IllegalStateException(attType + " is an invalid gauge threshold type");
            }
        }

        public ObjectName getPattern() {
            return this._pattern;
        }

        public void setPattern(ObjectName pattern) {
            this._pattern = pattern;
        }

        public Class getAttributeType() {
            return this._attType;
        }

        public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
            super.preRegister(server, name);
            return new ObjectName("AgentService:type=gaugeMonitor,observer=" + this._i + ",attributeType=" + this._attType.getName());
        }
    }

    class MyCounterMonitor
    extends CounterMonitor
    implements AgentMonitorMBean {
        private ObjectName _pattern;
        private int _i;
        private Class _attType;

        MyCounterMonitor(int i, Class attType) throws JMException {
            this._pattern = new ObjectName("*:*");
            this._i = i;
            this._attType = attType;
        }

        MyCounterMonitor(MyCounterMonitor g, Class attType) throws MalformedObjectNameException {
            this._pattern = g.getPattern();
            this._i = g._i;
            this._attType = attType;
            this.setObservedAttribute(g.getObservedAttribute());
            this.setGranularityPeriod(g.getGranularityPeriod());
            this.setDifferenceMode(g.getDifferenceMode());
            this.setNotify(g.getNotify());
            if (attType.equals(class$java$lang$Long == null ? (class$java$lang$Long = AgentContext.class$("java.lang.Long")) : class$java$lang$Long)) {
                this.setInitThreshold(new Long(g.getInitThreshold().longValue()));
                this.setModulus(new Long(g.getModulus().longValue()));
                this.setOffset(new Long(g.getOffset().longValue()));
            } else if (attType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = AgentContext.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                this.setInitThreshold(new Integer(g.getInitThreshold().intValue()));
                this.setModulus(new Integer(g.getModulus().intValue()));
                this.setOffset(new Integer(g.getOffset().intValue()));
            } else if (attType.equals(class$java$lang$Short == null ? (class$java$lang$Short = AgentContext.class$("java.lang.Short")) : class$java$lang$Short)) {
                this.setInitThreshold(new Short(g.getInitThreshold().shortValue()));
                this.setModulus(new Short(g.getModulus().shortValue()));
                this.setOffset(new Short(g.getOffset().shortValue()));
            } else if (attType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = AgentContext.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                this.setInitThreshold(new Byte(g.getInitThreshold().byteValue()));
                this.setModulus(new Byte(g.getModulus().byteValue()));
                this.setOffset(new Byte(g.getOffset().byteValue()));
            } else {
                throw new IllegalStateException(attType + " is an invalid counter threshold type");
            }
        }

        public ObjectName getPattern() {
            return this._pattern;
        }

        public void setPattern(ObjectName pattern) {
            this._pattern = pattern;
        }

        public Class getAttributeType() {
            return this._attType;
        }

        public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
            super.preRegister(server, name);
            return new ObjectName("AgentService:type=counterMonitor,observer=" + this._i + ",attributeType=" + this._attType.getName());
        }
    }

    class MyStringMonitor
    extends StringMonitor
    implements AgentMonitorMBean {
        private ObjectName _pattern = new ObjectName("*:*");
        private int _i;

        MyStringMonitor(int i) throws JMException {
            this._i = i;
        }

        public ObjectName getPattern() {
            return this._pattern;
        }

        public void setPattern(ObjectName pattern) {
            this._pattern = pattern;
        }

        public Class getAttributeType() {
            return class$java$lang$String == null ? (class$java$lang$String = AgentContext.class$("java.lang.String")) : class$java$lang$String;
        }

        public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
            super.preRegister(server, name);
            return new ObjectName("AgentService:type=stringMonitor,observer=" + this._i);
        }
    }
}

