/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.jmx.julia.stat;

import org.objectweb.fractal.jmx.julia.stat.StatController;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;

public class BasicStatController
implements StatController,
Initializable {
    protected long _period = 5000L;
    private int _calls;
    private int _callsCrtSample;
    private double _rateOfMethodCall;
    private int _success;
    private int _successCrtSample;
    private double _rateOfMethodSuccess;
    private long _startSample = System.currentTimeMillis();

    public void initialize(Tree args) {
        if (args.getSize() == 0) {
            return;
        }
        this._period = Long.valueOf(args.getSubTree(0).toString());
        if (this._period < 1L) {
            throw new IllegalStateException("period=" + this._period + " is invalid. The value must be positive.");
        }
    }

    public synchronized void reset() {
        this._calls = 0;
        this._callsCrtSample = 0;
        this._rateOfMethodCall = 0.0;
        this._success = 0;
        this._successCrtSample = 0;
        this._rateOfMethodSuccess = 0.0;
        this._startSample = System.currentTimeMillis();
    }

    public int getNumberOfMethodCall() {
        return this._calls;
    }

    public int getNumberOfMethodSuccess() {
        return this._success;
    }

    public double getRateOfMethodCall() {
        this.resetSample();
        return this._rateOfMethodCall;
    }

    public double getRateOfMethodSuccess() {
        this.resetSample();
        return this._rateOfMethodSuccess;
    }

    private synchronized void resetSample() {
        long t = System.currentTimeMillis();
        if (t < this._startSample + this._period) {
            return;
        }
        this._rateOfMethodCall = (double)(this._callsCrtSample * 1000) / (double)(t - this._startSample);
        this._callsCrtSample = 0;
        this._rateOfMethodSuccess = (double)(this._successCrtSample * 1000) / (double)(t - this._startSample);
        this._successCrtSample = 0;
        this._startSample = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statPreMethod(String method) {
        BasicStatController basicStatController = this;
        synchronized (basicStatController) {
            ++this._calls;
            ++this._callsCrtSample;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statPostMethod(String method) {
        BasicStatController basicStatController = this;
        synchronized (basicStatController) {
            ++this._success;
            ++this._successCrtSample;
        }
    }
}

