/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.descriptor.original;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Identification;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;

public class JBIDescriptorBuilderTestCase
extends TestCase {
    private static final String BCSOAP_JBI_DESC = "bcsoap.jbi.xml";

    public void testBuildXmlStringJBIDescriptor_001() throws JBIDescriptorException, IOException {
        InputStream jbiDescriptorStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(BCSOAP_JBI_DESC);
        Jbi bcSoapJbiDesc = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorStream);
        Component comp = bcSoapJbiDesc.getComponent();
        JBIDescriptorBuilderTestCase.assertNotNull((Object)comp);
        Identification ident = comp.getIdentification();
        JBIDescriptorBuilderTestCase.assertNotNull((Object)ident);
        ident.setDescription("My french characters: [\u00e9\u00e8\u00e7\u00e0\u00f9\u20ac\u00ef\u00ee\u00ea]");
        File tempJbiDescr = File.createTempFile("bcsoap", "jbi.xml");
        FileOutputStream os = new FileOutputStream(tempJbiDescr);
        JBIDescriptorBuilder.writeJBIdescriptor((Jbi)bcSoapJbiDesc, (OutputStream)os);
        ((OutputStream)os).close();
        FileInputStream is = new FileInputStream(tempJbiDescr);
        Jbi tempJbiDesc = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)is);
        JBIDescriptorBuilderTestCase.assertNotNull((Object)tempJbiDesc);
    }
}

