/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi;

import com.ebmwebsourcing.easycommons.reflect.ReflectionHelper;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public abstract class ApiChecker
extends TestCase {
    protected abstract Class<?> getTestedApiClass();

    protected Method getTestedClassMethod(String methodName, Class<?> ... parameterTypes) {
        return ReflectionHelper.getPublicMethod(this.getTestedApiClass(), (String)methodName, (Class[])parameterTypes);
    }

    protected void checkMethodThrowsExpectedExceptions(Method method, Class<?>[] expectedExceptions) {
        this.checkRuntimeExceptionsAreSubclassOfExpectedExceptions(method.getExceptionTypes(), expectedExceptions);
    }

    private void checkRuntimeExceptionsAreSubclassOfExpectedExceptions(Class<?>[] runtimeExceptions, Class<?>[] expectedExceptions) {
        for (Class<?> runtimeException : runtimeExceptions) {
            if (this.isRuntimeClassSubclassOfExpectedClasses(runtimeException, expectedExceptions)) continue;
            ApiChecker.fail((String)("Exception '" + runtimeException.getSimpleName() + "' isn't a subclass of expected exceptions"));
        }
    }

    private boolean isRuntimeClassSubclassOfExpectedClasses(Class<?> runtimeClass, Class<?>[] expectedClasses) {
        boolean isSubclass = false;
        for (Class<?> expectedClass : expectedClasses) {
            if (!expectedClass.isAssignableFrom(runtimeClass)) continue;
            isSubclass = true;
            break;
        }
        return isSubclass;
    }
}

