/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.component;

import java.lang.reflect.Method;
import javax.jbi.ApiChecker;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.ObjectName;
import org.mockito.Mockito;

public class BootstrapTest
extends ApiChecker {
    private Bootstrap mockBootstrap = (Bootstrap)Mockito.mock(Bootstrap.class);
    private InstallationContext installContextMock = (InstallationContext)Mockito.mock(InstallationContext.class);

    public void testcleanUp() throws JBIException {
        this.mockBootstrap.cleanUp();
    }

    public void testcleanUpThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("cleanUp", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testGetExtensionMBeanName() {
        ObjectName objectName = this.mockBootstrap.getExtensionMBeanName();
    }

    public void testInit() throws JBIException {
        this.mockBootstrap.init(this.installContextMock);
    }

    public void testInitThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("init", InstallationContext.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testOnInstall() throws JBIException {
        this.mockBootstrap.onInstall();
    }

    public void testOnInstallThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("onInstall", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testOnUninstall() throws JBIException {
        this.mockBootstrap.onUninstall();
    }

    public void testOnUninstallThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("onUninstall", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return Bootstrap.class;
    }
}

