/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.component;

import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.ApiChecker;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class ComponentContextTest
extends ApiChecker {
    private ComponentContext mockComponentContext = (ComponentContext)Mockito.mock(ComponentContext.class);
    private DocumentFragment mockDocumentFragment = (DocumentFragment)Mockito.mock(DocumentFragment.class);
    private ServiceEndpoint mockServiceEndpoint = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);

    public void testActivateEndpoint() throws JBIException {
        ServiceEndpoint serviceEndpoint = this.mockComponentContext.activateEndpoint(new QName("foo"), "bar");
    }

    public void testActivateEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("activateEndpoint", QName.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testDeactivateEndpoint() throws JBIException {
        this.mockComponentContext.deactivateEndpoint(this.mockServiceEndpoint);
    }

    public void testDeactivateEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("deactivateEndpoint", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testDeregisterExternalEndpoint() throws JBIException {
        this.mockComponentContext.deregisterExternalEndpoint(this.mockServiceEndpoint);
    }

    public void testDeregisterExternalEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("deregisterExternalEndpoint", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testGetComponentName() {
        String componentName = this.mockComponentContext.getComponentName();
    }

    public void testGetDeliveryChannel() throws MessagingException {
        DeliveryChannel deliveryChannel = this.mockComponentContext.getDeliveryChannel();
    }

    public void testGetDeliveryChannelThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("getDeliveryChannel", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testGetEndpoint() {
        ServiceEndpoint serviceEndpoint = this.mockComponentContext.getEndpoint(new QName("bar"), "foo");
    }

    public void testGetEndpointDescriptor() throws JBIException {
        Document document = this.mockComponentContext.getEndpointDescriptor(this.mockServiceEndpoint);
    }

    public void testGetEndpointDescriptorThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("getEndpointDescriptor", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testGetEndpoints() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getEndpoints(new QName("bar"));
    }

    public void testGetEndpointsForService() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getEndpointsForService(new QName("bar"));
    }

    public void testGetExternalEndpoints() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getExternalEndpoints(new QName("bar"));
    }

    public void testGetExternalEndpointsForService() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getExternalEndpointsForService(new QName("bar"));
    }

    public void testGetInstallRoot() {
        String installRoot = this.mockComponentContext.getInstallRoot();
    }

    public void testGetLogger() throws MissingResourceException, JBIException {
        Logger logger = this.mockComponentContext.getLogger("suffix", "resourceBundleName");
    }

    public void testGetLoggerThrowsMissingRessourceExceptionAndJBIException() {
        Class[] expectedExceptions = new Class[]{MissingResourceException.class, JBIException.class};
        Method method = this.getTestedClassMethod("getLogger", String.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testGetMBeanNames() {
        MBeanNames mBeanNames = this.mockComponentContext.getMBeanNames();
    }

    public void testGetMBeanServer() {
        MBeanServer mBeanServer = this.mockComponentContext.getMBeanServer();
    }

    public void testGetNamingContext() {
        InitialContext initialContext = this.mockComponentContext.getNamingContext();
    }

    public void testGetTransactionManager() {
        Object object = this.mockComponentContext.getTransactionManager();
    }

    public void testGetWorkspaceRoot() {
        String workspaceRoot = this.mockComponentContext.getWorkspaceRoot();
    }

    public void testRegisterExternalEndpoint() throws JBIException {
        this.mockComponentContext.registerExternalEndpoint(this.mockServiceEndpoint);
    }

    public void testRegisterExternalEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("registerExternalEndpoint", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testResolveEndpointReference() {
        ServiceEndpoint endpoint = this.mockComponentContext.resolveEndpointReference(this.mockDocumentFragment);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return ComponentContext.class;
    }
}

