/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.mockito.Mockito;

public class DeliveryChannelTest
extends ApiChecker {
    private MessageExchange mockMessageExchange = (MessageExchange)Mockito.mock(MessageExchange.class);
    DeliveryChannel mockDeliveryChannel = (DeliveryChannel)Mockito.mock(DeliveryChannel.class);

    public MessageExchange accept() throws MessagingException {
        return this.mockDeliveryChannel.accept();
    }

    public void testAccept(long timeoutMS) throws MessagingException, IllegalArgumentException {
        MessageExchange messageExchange = this.mockDeliveryChannel.accept(timeoutMS);
    }

    public void testAcceptThrowsMessagingExceptionAndIllegalArgumentException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class, IllegalArgumentException.class};
        Method method = this.getTestedClassMethod("accept", Long.TYPE);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testClose() throws MessagingException {
        this.mockDeliveryChannel.close();
    }

    public void testCloseThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("close", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateExchangeFactory() {
        MessageExchangeFactory messageExchangeFactory = this.mockDeliveryChannel.createExchangeFactory();
    }

    public void testCreateExchangeFactoryFromIntName() {
        MessageExchangeFactory messageExchangeFactory = this.mockDeliveryChannel.createExchangeFactory(new QName("foo"));
    }

    public void testCreateExchangeFactoryFromEp() {
        MessageExchangeFactory messageExchangeFactory = this.mockDeliveryChannel.createExchangeFactory((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class));
    }

    public void testCreateExchangeFactoryForService() {
        MessageExchangeFactory messageExchangeFactory = this.mockDeliveryChannel.createExchangeFactoryForService(new QName("foo"));
    }

    public void testSend() throws MessagingException {
        this.mockDeliveryChannel.send(this.mockMessageExchange);
    }

    public void testSendThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("send", MessageExchange.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testSendSync() throws MessagingException {
        boolean b = this.mockDeliveryChannel.sendSync(this.mockMessageExchange);
    }

    public void testSendSyncThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("sendSync", MessageExchange.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testSendSyncWithTimeout() throws MessagingException {
        boolean b = this.mockDeliveryChannel.sendSync(this.mockMessageExchange, 1L);
    }

    public void testSendSyncWithTimeoutThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("sendSync", MessageExchange.class, Long.TYPE);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return DeliveryChannel.class;
    }
}

