/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.mockito.Mockito;

public class MessageExchangeFactoryTest
extends ApiChecker {
    MessageExchangeFactory mockMessageExchangeFactory = (MessageExchangeFactory)Mockito.mock(MessageExchangeFactory.class);

    public void testCreateExchange() throws MessagingException {
        MessageExchange messageExchange = this.mockMessageExchangeFactory.createExchange(new QName("foo"), new QName("bar"));
    }

    public void testCreateExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createExchange", QName.class, QName.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateExchangeFromURI() throws MessagingException, URISyntaxException {
        MessageExchange messageExchange = this.mockMessageExchangeFactory.createExchange(new URI("http://foo.com"));
    }

    public void testCreateExchangeFromURIThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createExchange", URI.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateInOnlyExchange() throws MessagingException {
        InOnly inOnly = this.mockMessageExchangeFactory.createInOnlyExchange();
    }

    public void testCreateInOnlyExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOnlyExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateInOptionalOutExchange() throws MessagingException {
        InOptionalOut inOptionalOut = this.mockMessageExchangeFactory.createInOptionalOutExchange();
    }

    public void testCreateInOptionalOutExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOptionalOutExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateInOutExchange() throws MessagingException {
        InOut inOut = this.mockMessageExchangeFactory.createInOutExchange();
    }

    public void testCreateInOutExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOutExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateRobustInOnlyExchange() throws MessagingException {
        RobustInOnly robustInOnly = this.mockMessageExchangeFactory.createRobustInOnlyExchange();
    }

    public void testCreateRobustInOnlyExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createRobustInOnlyExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateExchangeWithProcessId() throws MessagingException {
        MessageExchange messageExchange = this.mockMessageExchangeFactory.createExchange(new QName("foo"), new QName("bar"), "foo");
    }

    public void testCreateExchangeWithProcessIdThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createExchange", QName.class, QName.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateExchangeFromURIWithProcessId() throws MessagingException, URISyntaxException {
        MessageExchange messageExchange = this.mockMessageExchangeFactory.createExchange(new URI("http://foo.com"), "foo");
    }

    public void testCreateExchangeFromURIWithProcessIdThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createExchange", URI.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateInOnlyExchangeWithProcessId() throws MessagingException {
        InOnly inOnly = this.mockMessageExchangeFactory.createInOnlyExchange("foo");
    }

    public void testCreateInOnlyExchangeWithProcessIdThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOnlyExchange", String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateInOptionalOutExchangeWithProcessId() throws MessagingException {
        InOptionalOut inOptionalOut = this.mockMessageExchangeFactory.createInOptionalOutExchange("foo");
    }

    public void testCreateInOptionalOutExchangeWithProcessIdThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOptionalOutExchange", String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateInOutExchangeWithProcessId() throws MessagingException {
        InOut inOut = this.mockMessageExchangeFactory.createInOutExchange("foo");
    }

    public void testCreateInOutExchangeWithProcessIdThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOutExchange", String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateRobustInOnlyExchangeWithProcessId() throws MessagingException {
        RobustInOnly robustInOnly = this.mockMessageExchangeFactory.createRobustInOnlyExchange("foo");
    }

    public void testCreateRobustInOnlyExchangeWithProcessIdThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createRobustInOnlyExchange", String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return MessageExchangeFactory.class;
    }
}

