/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.mockito.Mockito;

public class MessageExchangeTest
extends ApiChecker {
    MessageExchange messageExchange = (MessageExchange)Mockito.mock(MessageExchange.class);

    public void testCreateFault() throws MessagingException {
        Fault fault = this.messageExchange.createFault();
    }

    public void testCreateFaultThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createFault", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testCreateMessage() throws MessagingException {
        NormalizedMessage normalizedMessage = this.messageExchange.createMessage();
    }

    public void testCreateMessageThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createMessage", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testgetEndpoint() {
        ServiceEndpoint endpoint = this.messageExchange.getEndpoint();
    }

    public void testGetError() {
        Exception exception = this.messageExchange.getError();
    }

    public void testGetExchangeId() {
        String string = this.messageExchange.getExchangeId();
    }

    public void testGetProcessInstanceId() {
        String string = this.messageExchange.getProcessInstanceId();
    }

    public void testGetFault() {
        Fault fault = this.messageExchange.getFault();
    }

    public void testGetInterfaceName() {
        QName qName = this.messageExchange.getInterfaceName();
    }

    public void testGetMessage() {
        NormalizedMessage normalizedMessage = this.messageExchange.getMessage("foo");
    }

    public void testGetOperation() {
        QName qName = this.messageExchange.getOperation();
    }

    public void testGetPattern() {
        URI uri = this.messageExchange.getPattern();
    }

    public void testGetProperty() {
        Object object = this.messageExchange.getProperty("");
    }

    public void testGetPropertyNames() {
        Set set = this.messageExchange.getPropertyNames();
    }

    public void testGetRole() {
        MessageExchange.Role role = this.messageExchange.getRole();
    }

    public void testGetService() {
        QName qName = this.messageExchange.getService();
    }

    public void testGetStatus() {
        ExchangeStatus exchangeStatus = this.messageExchange.getStatus();
    }

    public void testIsTransacted() {
        boolean b = this.messageExchange.isTransacted();
    }

    public void testSetEndpoint() {
        this.messageExchange.setEndpoint((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class));
    }

    public void testSetError() {
        this.messageExchange.setError(new Exception());
    }

    public void testSetFault() throws MessagingException {
        this.messageExchange.setFault((Fault)Mockito.mock(Fault.class));
    }

    public void testSetFaultThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setFault", Fault.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testSetInterfaceName() {
        this.messageExchange.setInterfaceName(new QName("foo"));
    }

    public void testSetMessage() throws MessagingException {
        this.messageExchange.setMessage((NormalizedMessage)Mockito.mock(NormalizedMessage.class), "foo");
    }

    public void testSetMessageThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setMessage", NormalizedMessage.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testSetOperation() {
        this.messageExchange.setOperation(new QName("foo"));
    }

    public void testSetProperty() {
        this.messageExchange.setProperty("foo", new Object());
    }

    public void testSetService() {
        this.messageExchange.setService(new QName("foo"));
    }

    public void testSetStatus() throws MessagingException {
        this.messageExchange.setStatus(ExchangeStatus.ACTIVE);
    }

    public void testSetStatusThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setStatus", ExchangeStatus.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return MessageExchange.class;
    }
}

