/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import org.mockito.Mockito;

public class NormalizedMessageTest
extends ApiChecker {
    NormalizedMessage mockNormalizedMessage = (NormalizedMessage)Mockito.mock(NormalizedMessage.class);

    public void testAddAttachment() throws MessagingException {
        this.mockNormalizedMessage.addAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
    }

    public void testAddAttachmentThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("addAttachment", String.class, DataHandler.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testGetAttachment() {
        DataHandler dataHandler = this.mockNormalizedMessage.getAttachment("foo");
    }

    public void testGetAttachmentNames() {
        Set set = this.mockNormalizedMessage.getAttachmentNames();
    }

    public void testGetContent() {
        Source source = this.mockNormalizedMessage.getContent();
    }

    public void testGetProperty() {
        Object object = this.mockNormalizedMessage.getProperty("foo");
    }

    public void testGetPropertyNames() {
        Set set = this.mockNormalizedMessage.getPropertyNames();
    }

    public void testGetSecuritySubject() {
        Subject subject = this.mockNormalizedMessage.getSecuritySubject();
    }

    public void testRemoveAttachment() throws MessagingException {
        this.mockNormalizedMessage.removeAttachment("foo");
    }

    public void testRemoveAttachmentThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("removeAttachment", String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testSetContent() throws MessagingException {
        this.mockNormalizedMessage.setContent((Source)Mockito.mock(Source.class));
    }

    public void testSetContentThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setContent", Source.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    public void testSetProperty() {
        this.mockNormalizedMessage.setProperty("foo", new Object());
    }

    public void testSetSecuritySubject() {
        this.mockNormalizedMessage.setSecuritySubject(new Subject());
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return NormalizedMessage.class;
    }
}

