/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.component;

import java.lang.reflect.Method;
import javax.jbi.ApiChecker;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.ObjectName;
import org.junit.Test;
import org.mockito.Mockito;

public class BootstrapTest
extends ApiChecker {
    private Bootstrap mockBootstrap = (Bootstrap)Mockito.mock(Bootstrap.class);
    private InstallationContext installContextMock = (InstallationContext)Mockito.mock(InstallationContext.class);

    @Test
    public void testcleanUp() throws JBIException {
        this.mockBootstrap.cleanUp();
    }

    @Test
    public void testcleanUpThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("cleanUp", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testGetExtensionMBeanName() {
        ObjectName objectName = this.mockBootstrap.getExtensionMBeanName();
    }

    @Test
    public void testInit() throws JBIException {
        this.mockBootstrap.init(this.installContextMock);
    }

    @Test
    public void testInitThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("init", InstallationContext.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testOnInstall() throws JBIException {
        this.mockBootstrap.onInstall();
    }

    @Test
    public void testOnInstallThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("onInstall", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testOnUninstall() throws JBIException {
        this.mockBootstrap.onUninstall();
    }

    @Test
    public void testOnUninstallThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("onUninstall", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return Bootstrap.class;
    }
}

