/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.component;

import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.ApiChecker;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class ComponentContextTest
extends ApiChecker {
    private ComponentContext mockComponentContext = (ComponentContext)Mockito.mock(ComponentContext.class);
    private DocumentFragment mockDocumentFragment = (DocumentFragment)Mockito.mock(DocumentFragment.class);
    private ServiceEndpoint mockServiceEndpoint = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);

    @Test
    public void testActivateEndpoint() throws JBIException {
        ServiceEndpoint serviceEndpoint = this.mockComponentContext.activateEndpoint(new QName("foo"), "bar");
    }

    @Test
    public void testActivateEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("activateEndpoint", QName.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testDeactivateEndpoint() throws JBIException {
        this.mockComponentContext.deactivateEndpoint(this.mockServiceEndpoint);
    }

    @Test
    public void testDeactivateEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("deactivateEndpoint", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testDeregisterExternalEndpoint() throws JBIException {
        this.mockComponentContext.deregisterExternalEndpoint(this.mockServiceEndpoint);
    }

    @Test
    public void testDeregisterExternalEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("deregisterExternalEndpoint", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testGetComponentName() {
        String componentName = this.mockComponentContext.getComponentName();
    }

    @Test
    public void testGetDeliveryChannel() throws MessagingException {
        DeliveryChannel deliveryChannel = this.mockComponentContext.getDeliveryChannel();
    }

    @Test
    public void testGetDeliveryChannelThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("getDeliveryChannel", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testGetEndpoint() {
        ServiceEndpoint serviceEndpoint = this.mockComponentContext.getEndpoint(new QName("bar"), "foo");
    }

    @Test
    public void testGetEndpointDescriptor() throws JBIException {
        Document document = this.mockComponentContext.getEndpointDescriptor(this.mockServiceEndpoint);
    }

    @Test
    public void testGetEndpointDescriptorThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("getEndpointDescriptor", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testGetEndpoints() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getEndpoints(new QName("bar"));
    }

    @Test
    public void testGetEndpointsForService() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getEndpointsForService(new QName("bar"));
    }

    @Test
    public void testGetExternalEndpoints() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getExternalEndpoints(new QName("bar"));
    }

    @Test
    public void testGetExternalEndpointsForService() {
        ServiceEndpoint[] serviceEndpoints = this.mockComponentContext.getExternalEndpointsForService(new QName("bar"));
    }

    @Test
    public void testGetInstallRoot() {
        String installRoot = this.mockComponentContext.getInstallRoot();
    }

    @Test
    public void testGetLogger() throws MissingResourceException, JBIException {
        Logger logger = this.mockComponentContext.getLogger("suffix", "resourceBundleName");
    }

    @Test
    public void testGetLoggerThrowsMissingRessourceExceptionAndJBIException() {
        Class[] expectedExceptions = new Class[]{MissingResourceException.class, JBIException.class};
        Method method = this.getTestedClassMethod("getLogger", String.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testGetMBeanNames() {
        MBeanNames mBeanNames = this.mockComponentContext.getMBeanNames();
    }

    @Test
    public void testGetMBeanServer() {
        MBeanServer mBeanServer = this.mockComponentContext.getMBeanServer();
    }

    @Test
    public void testGetNamingContext() {
        InitialContext initialContext = this.mockComponentContext.getNamingContext();
    }

    @Test
    public void testGetTransactionManager() {
        Object object = this.mockComponentContext.getTransactionManager();
    }

    @Test
    public void testGetWorkspaceRoot() {
        String workspaceRoot = this.mockComponentContext.getWorkspaceRoot();
    }

    @Test
    public void testRegisterExternalEndpoint() throws JBIException {
        this.mockComponentContext.registerExternalEndpoint(this.mockServiceEndpoint);
    }

    @Test
    public void testRegisterExternalEndpointThrowsJBIException() {
        Class[] expectedExceptions = new Class[]{JBIException.class};
        Method method = this.getTestedClassMethod("registerExternalEndpoint", ServiceEndpoint.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testResolveEndpointReference() {
        ServiceEndpoint endpoint = this.mockComponentContext.resolveEndpointReference(this.mockDocumentFragment);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return ComponentContext.class;
    }
}

