/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mockito.Mockito;

public class MessageExchangeFactoryTest
extends ApiChecker {
    MessageExchangeFactory mockMessageExchangeFactory = (MessageExchangeFactory)Mockito.mock(MessageExchangeFactory.class);

    @Test
    public void testCreateExchange() throws MessagingException {
        MessageExchange messageExchange = this.mockMessageExchangeFactory.createExchange(new QName("foo"), new QName("bar"));
    }

    @Test
    public void testCreateExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createExchange", QName.class, QName.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testCreateExchangeFromURI() throws MessagingException, URISyntaxException {
        MessageExchange messageExchange = this.mockMessageExchangeFactory.createExchange(new URI("http://foo.com"));
    }

    @Test
    public void testCreateExchangeFromURIThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createExchange", URI.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testCreateInOnlyExchange() throws MessagingException {
        InOnly inOnly = this.mockMessageExchangeFactory.createInOnlyExchange();
    }

    @Test
    public void testCreateInOnlyExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOnlyExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testCreateInOptionalOutExchange() throws MessagingException {
        InOptionalOut inOptionalOut = this.mockMessageExchangeFactory.createInOptionalOutExchange();
    }

    @Test
    public void testCreateInOptionalOutExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOptionalOutExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testCreateInOutExchange() throws MessagingException {
        InOut inOut = this.mockMessageExchangeFactory.createInOutExchange();
    }

    @Test
    public void testCreateInOutExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createInOutExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testCreateRobustInOnlyExchange() throws MessagingException {
        RobustInOnly robustInOnly = this.mockMessageExchangeFactory.createRobustInOnlyExchange();
    }

    @Test
    public void testCreateRobustInOnlyExchangeThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createRobustInOnlyExchange", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return MessageExchangeFactory.class;
    }
}

