/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.petals.commons.log.FlowAttributes;

public class MessageExchangeTest
extends ApiChecker {
    MessageExchange messageExchange = (MessageExchange)Mockito.mock(MessageExchange.class);

    @Test
    public void testCreateFault() throws MessagingException {
        Fault fault = this.messageExchange.createFault();
    }

    @Test
    public void testCreateFaultThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createFault", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testCreateMessage() throws MessagingException {
        NormalizedMessage normalizedMessage = this.messageExchange.createMessage();
    }

    @Test
    public void testCreateMessageThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("createMessage", new Class[0]);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testgetEndpoint() {
        ServiceEndpoint endpoint = this.messageExchange.getEndpoint();
    }

    @Test
    public void testGetError() {
        Exception exception = this.messageExchange.getError();
    }

    @Test
    public void testGetExchangeId() {
        String string = this.messageExchange.getExchangeId();
    }

    @Test
    public void testGetFlowAttributes() {
        FlowAttributes flowAttributes = this.messageExchange.getFlowAttributes();
    }

    @Test
    public void testGetFault() {
        Fault fault = this.messageExchange.getFault();
    }

    @Test
    public void testGetInterfaceName() {
        QName qName = this.messageExchange.getInterfaceName();
    }

    @Test
    public void testGetMessage() {
        NormalizedMessage normalizedMessage = this.messageExchange.getMessage("foo");
    }

    @Test
    public void testGetOperation() {
        QName qName = this.messageExchange.getOperation();
    }

    @Test
    public void testGetPattern() {
        URI uri = this.messageExchange.getPattern();
    }

    @Test
    public void testGetProperty() {
        Object object = this.messageExchange.getProperty("");
    }

    @Test
    public void testGetPropertyNames() {
        Set set = this.messageExchange.getPropertyNames();
    }

    @Test
    public void testGetRole() {
        MessageExchange.Role role = this.messageExchange.getRole();
    }

    @Test
    public void testGetService() {
        QName qName = this.messageExchange.getService();
    }

    @Test
    public void testGetStatus() {
        ExchangeStatus exchangeStatus = this.messageExchange.getStatus();
    }

    @Test
    public void testIsTransacted() {
        boolean b = this.messageExchange.isTransacted();
    }

    @Test
    public void testSetEndpoint() {
        this.messageExchange.setEndpoint((ServiceEndpoint)Mockito.mock(ServiceEndpoint.class));
    }

    @Test
    public void testSetError() {
        this.messageExchange.setError(new Exception());
    }

    @Test
    public void testSetFault() throws MessagingException {
        this.messageExchange.setFault((Fault)Mockito.mock(Fault.class));
    }

    @Test
    public void testSetFaultThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setFault", Fault.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testSetInterfaceName() {
        this.messageExchange.setInterfaceName(new QName("foo"));
    }

    @Test
    public void testSetMessage() throws MessagingException {
        this.messageExchange.setMessage((NormalizedMessage)Mockito.mock(NormalizedMessage.class), "foo");
    }

    @Test
    public void testSetMessageThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setMessage", NormalizedMessage.class, String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testSetOperation() {
        this.messageExchange.setOperation(new QName("foo"));
    }

    @Test
    public void testSetProperty() {
        this.messageExchange.setProperty("foo", new Object());
    }

    @Test
    public void testSetService() {
        this.messageExchange.setService(new QName("foo"));
    }

    @Test
    public void testSetStatus() throws MessagingException {
        this.messageExchange.setStatus(ExchangeStatus.ACTIVE);
    }

    @Test
    public void testSetStatusThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setStatus", ExchangeStatus.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return MessageExchange.class;
    }
}

