/*
 * Decompiled with CFR 0.152.
 */
package javax.jbi.messaging;

import java.lang.reflect.Method;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.ApiChecker;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import org.junit.Test;
import org.mockito.Mockito;

public class NormalizedMessageTest
extends ApiChecker {
    NormalizedMessage mockNormalizedMessage = (NormalizedMessage)Mockito.mock(NormalizedMessage.class);

    @Test
    public void testAddAttachment() throws MessagingException {
        this.mockNormalizedMessage.addAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
    }

    @Test
    public void testAddAttachmentThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("addAttachment", String.class, DataHandler.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testGetAttachment() {
        DataHandler dataHandler = this.mockNormalizedMessage.getAttachment("foo");
    }

    @Test
    public void testGetAttachmentNames() {
        Set set = this.mockNormalizedMessage.getAttachmentNames();
    }

    @Test
    public void testGetContent() {
        Source source = this.mockNormalizedMessage.getContent();
    }

    @Test
    public void testGetProperty() {
        Object object = this.mockNormalizedMessage.getProperty("foo");
    }

    @Test
    public void testGetPropertyNames() {
        Set set = this.mockNormalizedMessage.getPropertyNames();
    }

    @Test
    public void testGetSecuritySubject() {
        Subject subject = this.mockNormalizedMessage.getSecuritySubject();
    }

    @Test
    public void testRemoveAttachment() throws MessagingException {
        this.mockNormalizedMessage.removeAttachment("foo");
    }

    @Test
    public void testRemoveAttachmentThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("removeAttachment", String.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testSetContent() throws MessagingException {
        this.mockNormalizedMessage.setContent((Source)Mockito.mock(Source.class));
    }

    @Test
    public void testSetContentThrowsMessagingException() {
        Class[] expectedExceptions = new Class[]{MessagingException.class};
        Method method = this.getTestedClassMethod("setContent", Source.class);
        this.checkMethodThrowsExpectedExceptions(method, expectedExceptions);
    }

    @Test
    public void testSetProperty() {
        this.mockNormalizedMessage.setProperty("foo", new Object());
    }

    @Test
    public void testSetSecuritySubject() {
        this.mockNormalizedMessage.setSecuritySubject(new Subject());
    }

    @Override
    protected Class<?> getTestedApiClass() {
        return NormalizedMessage.class;
    }
}

