/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.petals.jmx.exception.ConnectionErrorException;

public final class JMXConnection {
    private String host = null;
    private int jndiPort;
    private String username = null;
    private String password = null;
    private JMXConnector connector = null;

    public JMXConnection(JMXConnector connector) throws ConnectionErrorException {
        if (connector == null) {
            throw new ConnectionErrorException("Can not connect using a null JMXConnector");
        }
        this.connector = connector;
    }

    public JMXConnection(String host, int jndiPort, String username, String password) throws ConnectionErrorException {
        this.host = host;
        this.jndiPort = jndiPort;
        this.username = username;
        this.password = password;
        StringBuffer jmxServiceURL = new StringBuffer(40);
        try {
            Properties env = System.getProperties();
            env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            HashMap<String, String[]> args = new HashMap<String, String[]>();
            if (!"".equals(this.username)) {
                if (this.password == null) {
                    this.password = "";
                }
                String[] credentials = new String[]{this.username, this.password};
                args.put("jmx.remote.credentials", credentials);
            }
            jmxServiceURL.append("service:jmx:rmi:///jndi/rmi://").append(this.host).append(":").append(this.jndiPort).append("/jmxRmiConnector");
            JMXServiceURL url = new JMXServiceURL(jmxServiceURL.toString());
            this.connector = JMXConnectorFactory.connect(url, args);
        }
        catch (MalformedURLException e) {
            throw new ConnectionErrorException(e);
        }
        catch (IOException e) {
            throw new ConnectionErrorException("Can not connect using URI : " + jmxServiceURL.toString() + " with " + username + "/" + password, e);
        }
        catch (SecurityException e) {
            throw new ConnectionErrorException(e);
        }
    }

    public MBeanServerConnection getMBeanServerConnection() throws ConnectionErrorException {
        try {
            return this.connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new ConnectionErrorException(e);
        }
    }

    public void disconnect() throws ConnectionErrorException {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                throw new ConnectionErrorException(e);
            }
        }
    }
}

