/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Test;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.InstallationServiceClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;
import org.ow2.petals.jmx.exception.InstallerComponentDoesNotExistException;

public class InstallationServiceClientTest {
    private static final String INEXISTING_COMPONENT_ID = "inexisting-component-id";
    private static final ObjectName INSTALLATION_SERVICE_OBJECT_NAME;

    public static Object getStaticPrivateField(Class<?> clazz, String fieldName) {
        Assert.assertNotNull(clazz);
        Assert.assertNotNull((Object)fieldName);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            if (Modifier.isStatic(fields[i].getModifiers())) {
                try {
                    fields[i].setAccessible(true);
                    return fields[i].get(clazz);
                }
                catch (IllegalAccessException ex) {
                    Assert.fail((String)("IllegalAccessException accessing " + fieldName));
                    continue;
                }
            }
            Assert.fail((String)("Field '" + fieldName + "' not static."));
        }
        Assert.fail((String)("Field '" + fieldName + "' not found"));
        return null;
    }

    private static MBeanServerConnection createMBeanServerConnectionMock() throws MalformedObjectNameException, IOException {
        MBeanServerConnection mBeanServerConnectionMock = (MBeanServerConnection)EasyMock.createMock(MBeanServerConnection.class);
        EasyMock.expect(mBeanServerConnectionMock.queryNames(INSTALLATION_SERVICE_OBJECT_NAME, null)).andAnswer((IAnswer)new IAnswer<Set<ObjectName>>(){

            public Set<ObjectName> answer() throws Throwable {
                TreeSet<ObjectName> objectName = new TreeSet<ObjectName>();
                objectName.add(INSTALLATION_SERVICE_OBJECT_NAME);
                return objectName;
            }
        });
        return mBeanServerConnectionMock;
    }

    @Test
    public void testLoadInstaller_NotLoaded() throws InstallationServiceDoesNotExistException, InstallationServiceErrorException, MalformedObjectNameException, IOException, InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanServerConnection mBeanServerConnectionMock = InstallationServiceClientTest.createMBeanServerConnectionMock();
        Object[] objects = new Object[]{INEXISTING_COMPONENT_ID};
        Object[] strings = new String[]{String.class.getName()};
        EasyMock.expect((Object)mBeanServerConnectionMock.invoke((ObjectName)EasyMock.eq((Object)INSTALLATION_SERVICE_OBJECT_NAME), (String)EasyMock.eq((Object)((String)InstallationServiceClientTest.getStaticPrivateField(InstallationServiceClient.class, "LOAD_INSTALLER"))), EasyMock.aryEq((Object[])objects), (String[])EasyMock.aryEq((Object[])strings))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{mBeanServerConnectionMock});
        InstallationServiceClient isc = new InstallationServiceClient("Petals", mBeanServerConnectionMock);
        try {
            isc.loadInstaller(INEXISTING_COMPONENT_ID);
            TestCase.fail((String)("The exception '" + InstallerComponentDoesNotExistException.class.getName() + "' is not thrown."));
        }
        catch (InstallerComponentDoesNotExistException e) {
            TestCase.assertEquals((String)INEXISTING_COMPONENT_ID, (String)e.getComponentName());
        }
    }

    static {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put((String)InstallationServiceClientTest.getStaticPrivateField(AbstractServiceClient.class, "JMX_FIELD_NAME"), (String)InstallationServiceClientTest.getStaticPrivateField(InstallationServiceClient.class, "INSTALLATION_SERVICE_JMX_NAME"));
        attributes.put((String)InstallationServiceClientTest.getStaticPrivateField(AbstractServiceClient.class, "JMX_FIELD_TYPE"), (String)InstallationServiceClientTest.getStaticPrivateField(AbstractServiceClient.class, "JMX_SERVICE_TYPE"));
        try {
            INSTALLATION_SERVICE_OBJECT_NAME = new ObjectName((String)InstallationServiceClientTest.getStaticPrivateField(JMXClient.class, "PETALS_DOMAIN"), attributes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

