/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.ws.api.to;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.ow2.petals.kernel.ws.api.to.JndiInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://petals.ow2.org/ws/1.0", name="domain-information")
public class DomainInformation {
    @XmlElement(name="domain-revision", required=true, nillable=false)
    private long revision;
    @XmlElement(name="domain-name", required=true, nillable=false)
    private String name;
    @XmlElement(name="domain-mode", required=true, nillable=false)
    private DomainMode mode;
    @XmlElement(name="domain-description", required=false, nillable=true)
    private String description;
    @XmlElement(name="domain-jndi", required=false, nillable=true)
    private JndiInformation jndi;
    @XmlElement(name="domain-subdomains", required=true, nillable=false)
    private List<SubdomainInformation> subdomains;

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DomainMode getMode() {
        return this.mode;
    }

    public void setMode(DomainMode mode) {
        this.mode = mode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JndiInformation getJndi() {
        return this.jndi;
    }

    public void setJndiInformation(JndiInformation jndi) {
        this.jndi = jndi;
    }

    public List<SubdomainInformation> getSubdomains() {
        return this.subdomains;
    }

    public void setSubdomains(List<SubdomainInformation> subdomains) {
        this.subdomains = subdomains;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainInformation other = (DomainInformation)obj;
        if (this.revision != other.revision) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!(this.jndi == other.jndi || this.jndi != null && this.jndi.equals(other.jndi))) {
            return false;
        }
        if (!(this.subdomains == other.subdomains || this.subdomains != null && ((Object)this.subdomains).equals(other.subdomains))) {
            return false;
        }
        if (this.subdomains != null && other.subdomains != null) {
            if (this.subdomains.size() != other.subdomains.size()) {
                return false;
            }
            for (SubdomainInformation container : this.subdomains) {
                if (other.subdomains.contains(container)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (int)(this.revision ^ this.revision >>> 32);
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 17 * hash + this.mode.hashCode();
        hash = 17 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 17 * hash + (this.jndi != null ? this.jndi.hashCode() : 0);
        hash = 17 * hash + (this.subdomains != null ? this.subdomains.size() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append("DomainInformation [");
        toStringBuilder.append("domain-name=").append(this.name).append(", ");
        toStringBuilder.append("domain-mode=").append((Object)this.mode).append(", ");
        toStringBuilder.append("domain-description=").append(this.description).append(", ");
        toStringBuilder.append("domain-jndi=").append(this.jndi).append(", ");
        toStringBuilder.append("domain-subdomains={");
        if (this.subdomains != null) {
            for (SubdomainInformation subdomain : this.subdomains) {
                toStringBuilder.append(subdomain).append(", ");
            }
        }
        toStringBuilder.append("}]");
        return toStringBuilder.toString();
    }

    @XmlEnum
    public static enum DomainMode {
        STANDALONE,
        STATIC,
        DYNAMIC;

    }
}

