/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jmx.rmi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.jmx.agent.AdminAttributes;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jmx.rmi.TimedRMIDirectConnectorFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
public class RMIConnector
implements BindingController,
LifeCycleController {
    private LoggerFactory loggerFactory;
    @Requires(name="adminAtt", signature=AdminAttributes.class)
    protected AdminAttributes adminAttributes;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    protected LoggingUtil log;
    protected Logger logger;
    protected JMXConnectorServer cs;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public static final String getJmxServiceURL(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("rmi://");
        stringBuffer.append(string).append(":").append(n);
        StringBuffer stringBuffer2 = new StringBuffer("service:jmx:");
        stringBuffer2.append(stringBuffer.toString()).append("/jndi/").append(stringBuffer.toString()).append("/jmxRmiConnector");
        return stringBuffer2.toString();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        try {
            ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
            String string = containerConfiguration.getHost();
            int n = containerConfiguration.getJmxRMIConnectorPort();
            long l = containerConfiguration.getTCPConnectionTimeout();
            System.setProperty("sun.rmi.transport.tcp.responseTimeout", Long.toString(l));
            System.setProperty("java.rmi.server.disableHttp", "true");
            TimedRMIDirectConnectorFactory timedRMIDirectConnectorFactory = new TimedRMIDirectConnectorFactory((int)l, string);
            RMISocketFactory.setSocketFactory((RMISocketFactory)((Object)timedRMIDirectConnectorFactory));
            Registry registry = LocateRegistry.getRegistry(n);
            try {
                registry.list();
            }
            catch (Exception exception) {
                LocateRegistry.createRegistry(n);
            }
            JMXServiceURL jMXServiceURL = new JMXServiceURL(RMIConnector.getJmxServiceURL(string, n));
            HashMap<String, Object> hashMap = this.setupJMXSecurity(containerConfiguration);
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, this.adminAttributes.getRawMBeanServer());
            this.cs.start();
        }
        catch (IOException iOException) {
            this.log.error((Object)"Failed to start JMX RMI connector service", (Throwable)iOException);
            throw iOException;
        }
        this.log.info((Object)("JMX RMI server started at : service:jmx:rmi://" + this.cs.getAddress().getURLPath()));
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
        if (this.cs != null) {
            try {
                this.cs.stop();
            }
            catch (Exception exception) {
                this.log.error((Object)"Failed to stop JMX RMI connector service", (Throwable)exception);
            }
        }
        this.log.end();
    }

    private HashMap<String, Object> setupJMXSecurity(ContainerConfiguration containerConfiguration) {
        Properties properties = new Properties();
        properties.put(containerConfiguration.getUser(), containerConfiguration.getPassword());
        Properties properties2 = new Properties();
        properties2.put(containerConfiguration.getUser(), "readwrite");
        File file = new File(containerConfiguration.getWorkDirectoryPath());
        File file2 = new File(file, "password.properties");
        File file3 = new File(file, "access.properties");
        try {
            properties.store(new FileOutputStream(file2), "role and password for JMX remote connection");
        }
        catch (IOException iOException) {
            this.log.error((Object)("Can not create " + file2.getAbsolutePath() + " file to store JMX password"));
        }
        try {
            properties2.store(new FileOutputStream(file3), "role and right for JMX remote connection");
        }
        catch (IOException iOException) {
            this.log.error((Object)("Can not create " + file3.getAbsolutePath() + " file to store JMX rights"));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("jmx.remote.x.password.file", file2.getAbsolutePath());
        hashMap.put("jmx.remote.x.access.file", file3.getAbsolutePath());
        return hashMap;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("adminAtt")) {
            if (!AdminAttributes.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminAttributes.class.getName());
            }
            this.adminAttributes = (AdminAttributes)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("adminAtt");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("adminAtt")) {
            return this.adminAttributes;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("adminAtt")) {
            this.adminAttributes = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

