/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.management.DeploymentException;
import org.apache.commons.io.IOUtils;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.TaskProcessor;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.deployment.DeploymentService;
import org.ow2.petals.jbi.management.task.deployment.DeploymentTaskFactory;
import org.ow2.petals.jbi.management.util.XMLResult;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ParameterCheckHelper;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=DeploymentService.class)})
public class DeploymentServiceImpl
implements BindingController,
LifeCycleController,
DeploymentService {
    private LoggerFactory loggerFactory;
    @Requires(name="container", signature=ContainerService.class)
    protected ContainerService container;
    @Requires(name="admin", signature=AdminService.class)
    private AdminService adminService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private DeploymentTaskFactory deploymentTaskFactory;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    private LoggingUtil log;
    private Logger logger;
    @Requires(name="repository", signature=RepositoryService.class)
    private RepositoryService repositoryService;
    @Requires(name="systemstate", signature=SystemStateService.class)
    private SystemStateService systemStateService;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean canDeployToComponent(String string) {
        this.log.call();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        boolean bl = false;
        Installer installer = this.adminService.getInstallerByName(string);
        if (installer.isInstalled() && installer.getComponent().getServiceUnitManager() != null) {
            bl = true;
        }
        return bl;
    }

    public String deploy(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullParameterWithLog(string, "serviceAssemblyZipUrl", this.log);
        String string2 = null;
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = new File(string).toURI().toURL();
            }
            Context context = this.createDeploymentContext(uRL);
            TaskProcessor taskProcessor = this.createDeploymentProcessor(context, uRL);
            Throwable throwable = taskProcessor.process();
            if (throwable != null) {
                throw new DeploymentException("The deployment of the Service Assembly '" + string + "' failed.", throwable);
            }
            string2 = context.getXmlResult().getString();
            if (string2.contains("<task-result>FAILED</task-result>")) {
                this.log.warning((Object)("Service Assembly '" + context.getEntityName() + "' deployed with some SU deployment in failure"));
            } else {
                this.log.info((Object)("Service Assembly '" + context.getEntityName() + "' deployed"));
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to deploy the service assembly at '" + string + "'"), (Throwable)exception);
            throw new Exception(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.end();
        return string2;
    }

    public boolean forceUndeploy(String string) {
        this.log.start();
        boolean bl = false;
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblies().get(string);
        if (serviceAssemblyLifeCycle != null) {
            serviceAssemblyLifeCycle.setForcedState(true);
        } else {
            this.log.warning((Object)("Cannot retrieve Service Assembly with the specified name : " + string));
        }
        try {
            if ("Started".equals(serviceAssemblyLifeCycle.getCurrentState()) || "Unknown".equals(serviceAssemblyLifeCycle.getCurrentState())) {
                this.stop(string, true);
            }
        }
        catch (Exception exception) {}
        try {
            if ("Stopped".equals(serviceAssemblyLifeCycle.getCurrentState())) {
                this.shutDown(string, true);
            }
        }
        catch (Exception exception) {}
        try {
            this.undeploy(string);
            bl = true;
        }
        catch (Exception exception) {}
        this.log.end();
        return bl;
    }

    public String[] getComponentsForDeployedServiceAssembly(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle != null) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                arrayList.add(serviceUnit.getTarget().getComponentName());
            }
        } else {
            throw new Exception("Cannot retrieve service assembly with the specified name: " + string);
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getDeployedServiceAssemblies() throws Exception {
        this.log.call();
        Set<String> set = this.adminService.getServiceAssemblies().keySet();
        return set.toArray(new String[set.size()]);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("container")) {
            if (!ContainerService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ContainerService.class.getName());
            }
            this.container = (ContainerService)object;
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("repository")) {
            if (!RepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RepositoryService.class.getName());
            }
            this.repositoryService = (RepositoryService)object;
            return;
        }
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemStateService = (SystemStateService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] getDeployedServiceAssembliesForComponent(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, ServiceAssemblyLifeCycle> map = this.adminService.getServiceAssemblies();
        for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : map.values()) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                if (!string.equals(serviceUnit.getTarget().getComponentName())) continue;
                hashSet.add(serviceAssemblyLifeCycle.getServiceAssembly().getIdentification().getName());
            }
        }
        this.log.end();
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("container");
        arrayList.add("admin");
        arrayList.add("configuration");
        arrayList.add("endpoint");
        arrayList.add("repository");
        arrayList.add("systemstate");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("container")) {
            return this.container;
        }
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("repository")) {
            return this.repositoryService;
        }
        if (string.equals("systemstate")) {
            return this.systemStateService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] getDeployedServiceUnitList(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, ServiceAssemblyLifeCycle> map = this.adminService.getServiceAssemblies();
        for (ServiceAssemblyLifeCycle serviceAssemblyLifeCycle : map.values()) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                if (!string.equals(serviceUnit.getTarget().getComponentName())) continue;
                hashSet.add(serviceUnit.getIdentification().getName());
            }
        }
        this.log.end();
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("container")) {
            this.container = null;
            return;
        }
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("repository")) {
            this.repositoryService = null;
            return;
        }
        if (string.equals("systemstate")) {
            this.systemStateService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String getServiceAssemblyDescriptor(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = "Service Assembly doesn't exist :" + string;
        File file = this.repositoryService.getServiceAssemblyInstallDirectory(string);
        if (file != null) {
            File file2 = new File(file, JBIDescriptorBuilder.JBI_DESCRIPTOR_RESOURCE);
            string2 = IOUtils.toString((InputStream)new FileInputStream(file2));
        }
        this.log.end();
        return string2;
    }

    public String[] getServiceUnitForServiceAssembly(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "saName", this.log);
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle != null) {
            List list = serviceAssemblyLifeCycle.getServiceAssembly().getServiceUnit();
            for (ServiceUnit serviceUnit : list) {
                arrayList.add(serviceUnit.getIdentification().getName());
            }
        } else {
            String string2 = "Cannot retrieve service assembly with the name '" + string + '\"';
            this.log.error((Object)string2);
            throw new Exception(string2);
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getState(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = null;
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
        if (serviceAssemblyLifeCycle == null) {
            String string3 = "Cannot retrieve service assembly with the specified name : " + string;
            this.log.error((Object)string3);
            throw new Exception(string3);
        }
        string2 = serviceAssemblyLifeCycle.getCurrentState();
        if (!("Shutdown".equals(string2) || "Started".equals(string2) || "Stopped".equals(string2) || "Unknown".equals(string2))) {
            String string4 = "Service Assembly state isn't correctly defined";
            this.log.error((Object)string4);
            throw new Exception(string4);
        }
        this.log.end();
        return string2;
    }

    public boolean isDeployedServiceUnit(String string, String string2) {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string2, "serviceUnitName", this.log);
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        boolean bl = false;
        List<ServiceUnitLifeCycle> list = this.adminService.getServiceUnitsLifeCyclesForComponent(string);
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
            if (!serviceUnitLifeCycle.getSuName().equals(string2)) continue;
            bl = true;
            break;
        }
        this.log.end();
        return bl;
    }

    public void shutdown() throws Exception {
        this.log.call();
        this.undeployAllServiceAssemblies(true);
    }

    public String shutDown(String string) throws Exception {
        return this.shutDown(string, false);
    }

    public String[] shutdownAllServiceAssemblies() {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        Collections.reverse(list);
        for (ServiceAssembly serviceAssembly : list) {
            try {
                this.shutDown(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String start(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = null;
        try {
            XMLResult xMLResult = new XMLResult("start");
            ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
            if (serviceAssemblyLifeCycle == null) {
                throw new DeploymentException("The service assembly '" + string + "' is not deployed");
            }
            serviceAssemblyLifeCycle.start();
            xMLResult.addFrameworkTaskResult(XMLResult.TaskResult.SUCCESS, XMLResult.MessageType.INFO, "Successfully started service assembly : {1}", new String[]{string}, null);
            string2 = xMLResult.getString();
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to start the service assembly '" + string + "'"), (Throwable)exception);
            throw new Exception(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.info((Object)("Service Assembly '" + string + "' started"));
        this.log.end();
        return string2;
    }

    public String[] startAllServiceAssemblies() {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ServiceAssembly serviceAssembly : this.systemStateService.getServiceAssemblyStateHolders()) {
            try {
                this.start(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String stop(String string) throws Exception {
        return this.stop(string, false);
    }

    public String[] stopAllServiceAssemblies() {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        Collections.reverse(list);
        for (ServiceAssembly serviceAssembly : list) {
            try {
                this.stop(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String undeploy(String string) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullParameterWithLog(string, "serviceAssemblyZipUrl", this.log);
        String string2 = null;
        try {
            ServiceAssembly serviceAssembly = this.systemStateService.getServiceAssemblyStateHolder(string);
            if (serviceAssembly == null) {
                throw new DeploymentException("The service assembly '" + string + "' is not deployed");
            }
            if (!"Shutdown".equals(serviceAssembly.getLifecycleState())) {
                throw new DeploymentException("The service assembly '" + string + "' is not at the state SHUTDOWN");
            }
            Context context = this.createUndeploymentContext(string);
            TaskProcessor taskProcessor = this.createUndeploymentProcessor(context);
            Throwable throwable = taskProcessor.process();
            if (throwable != null) {
                throw new DeploymentException("The undeployment of the Service Assembly '" + string + "' failed.", throwable);
            }
            string2 = context.getXmlResult().getString();
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to undeploy the service assembly '" + string + "'"), (Throwable)exception);
            throw new Exception(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.info((Object)("Service Assembly '" + string + "' undeployed"));
        this.log.end();
        return string2;
    }

    public String[] undeployAllServiceAssemblies(boolean bl) {
        this.log.start();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        Collections.reverse(list);
        for (ServiceAssembly serviceAssembly : list) {
            if (bl) {
                if (!this.forceUndeploy(serviceAssembly.getName())) continue;
                arrayList.add(serviceAssembly.getName());
                continue;
            }
            if (!"Shutdown".equals(serviceAssembly.getLifecycleState())) continue;
            try {
                this.undeploy(serviceAssembly.getName());
                arrayList.add(serviceAssembly.getName());
            }
            catch (Throwable throwable) {}
        }
        this.log.end();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.deploymentTaskFactory = new DeploymentTaskFactory(this.endpointRegistry, this, this.systemStateService, this.repositoryService, this.log, this.adminService, this.container, this.configurationService.getContainerConfiguration().getRootDirectoryPath());
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    private Context createDeploymentContext(URL uRL) {
        this.log.call();
        Context context = new Context();
        context.setArchiveUrl(uRL);
        return context;
    }

    private TaskProcessor createDeploymentProcessor(Context context, URL uRL) {
        this.log.call();
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        String string = uRL.getProtocol();
        if (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("ftp")) {
            taskProcessor.addTask(this.deploymentTaskFactory.getDownloadTask());
        } else if (string.equalsIgnoreCase("file")) {
            taskProcessor.addTask(this.deploymentTaskFactory.getCopyArchiveToWorkDirTask());
        } else {
            throw new IllegalArgumentException("URL protocol not supported:" + string);
        }
        taskProcessor.addTask(this.deploymentTaskFactory.getExtractTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getSaCheckPackageTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCopySAPackageToRepositoryTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateSAStateHolderTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateXMLDeploymentResultTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getExtractSUsTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRegisterSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getDeployAllSUTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRegisterAllConnectionTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCopyArchiveToInstalledDirTask());
        return taskProcessor;
    }

    private Context createUndeploymentContext(String string) {
        this.log.call();
        Context context = new Context();
        ServiceAssembly serviceAssembly = this.systemStateService.getServiceAssemblyStateHolder(string);
        context.setEntityName(string);
        try {
            context.setArchiveUrl(new URL(serviceAssembly.getInstallURL()));
        }
        catch (MalformedURLException malformedURLException) {}
        return context;
    }

    private TaskProcessor createUndeploymentProcessor(Context context) {
        this.log.call();
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateXMLUndeploymentResultTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRetrieveSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getUndeployAllSUTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveAllConnectionsTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getUnregisterSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveSAStateHolderTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveSAFolderTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRemoveSAArchiveTask());
        return taskProcessor;
    }

    private String shutDown(String string, boolean bl) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = null;
        try {
            XMLResult xMLResult = new XMLResult("shutdown");
            ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
            if (serviceAssemblyLifeCycle == null) {
                throw new DeploymentException("The service assembly '" + string + "' is not deployed");
            }
            serviceAssemblyLifeCycle.setForcedState(bl);
            serviceAssemblyLifeCycle.shutDown();
            xMLResult.addFrameworkTaskResult(XMLResult.TaskResult.SUCCESS, XMLResult.MessageType.INFO, "Successfully shutdown service assembly : {1}", new String[]{string}, null);
            string2 = xMLResult.getString();
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to shutdown the service assembly '" + string + "'"), (Throwable)exception);
            throw new Exception(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.info((Object)("Service Assembly '" + string + "' shut down"));
        this.log.end();
        return string2;
    }

    private String stop(String string, boolean bl) throws Exception {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "serviceAssemblyName", this.log);
        String string2 = null;
        try {
            ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string);
            if (serviceAssemblyLifeCycle == null) {
                throw new DeploymentException("The service assembly '" + string + "' is not deployed");
            }
            serviceAssemblyLifeCycle.setForcedState(bl);
            serviceAssemblyLifeCycle.stop();
            XMLResult xMLResult = new XMLResult("stop");
            xMLResult.addFrameworkTaskResult(XMLResult.TaskResult.SUCCESS, XMLResult.MessageType.INFO, "Successfully stopped service assembly : {1}", new String[]{string}, null);
            string2 = xMLResult.getString();
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to stop the service assembly '" + string + "'"), (Throwable)exception);
            throw new Exception(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.info((Object)("Service Assembly '" + string + "' stopped"));
        this.log.end();
        return string2;
    }
}

