/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import java.io.File;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractCheckPackageTask;
import org.ow2.petals.jbi.management.task.installation.InstallationUtils;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.StringHelper;

public class ComponentCheckPackageTask
extends AbstractCheckPackageTask {
    protected AdminService adminService;

    public ComponentCheckPackageTask(LoggingUtil loggingUtil, AdminService adminService) {
        super(loggingUtil);
        this.adminService = adminService;
    }

    protected void checkPackage(Jbi jbi, File file) throws PetalsException {
        Component component = jbi.getComponent();
        if (component == null) {
            throw new PetalsException("The component production element was not found in JBI Descriptor within installation package: " + file.getAbsolutePath());
        }
        String string = component.getIdentification().getName();
        if (StringHelper.isNullOrEmpty(string)) {
            throw new PetalsException("The component name must be non null and non empty for the new component :" + file.getAbsolutePath());
        }
        if (this.adminService.getInstallerByName(string) != null) {
            throw new PetalsException("Other installation package already exists loaded in the component framework: " + string);
        }
        InstallationUtils.checkClassPathElements(file, component.getBootstrapClassPath().getPathElement());
        InstallationUtils.checkClassPathElements(file, component.getComponentClassPath().getPathElement());
    }

    protected String extractEntityName(Jbi jbi) {
        return jbi.getComponent().getIdentification().getName();
    }
}

