/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.transaction;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.transaction.PetalsTransactionContext;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=TransactionManager.class)})
public class TransactionManagerImpl
implements TransactionManager,
BindingController,
LifeCycleController {
    private LoggerFactory loggerFactory;
    private static Current current;
    protected LoggingUtil log;
    protected Logger logger;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public static final void decodeTransactionContext(MessageExchangeDecorator messageExchangeDecorator) {
        PetalsTransactionContext petalsTransactionContext = (PetalsTransactionContext)messageExchangeDecorator.getProperty("javax.jbi.transaction.jta");
        if (petalsTransactionContext != null) {
            XidImpl xidImpl = new XidImpl(petalsTransactionContext.formatID, petalsTransactionContext.globalTransactionID, petalsTransactionContext.branchQualifier);
            InternalTransactionContext internalTransactionContext = new InternalTransactionContext(petalsTransactionContext.timeOut, petalsTransactionContext.coordinator, (javax.transaction.xa.Xid)xidImpl);
            current.setPropagationContext((TransactionContext)internalTransactionContext, false);
            messageExchangeDecorator.setProperty("javax.jbi.transaction.jta", new TransactionImpl((TransactionContext)internalTransactionContext));
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public static final void encodeTransactionContext(MessageExchangeDecorator messageExchangeDecorator) throws SystemException {
        Object object;
        TransactionContext transactionContext = null;
        if (messageExchangeDecorator.getProperty("javax.jbi.transaction.jta") instanceof TransactionImpl) {
            object = (TransactionImpl)messageExchangeDecorator.getProperty("javax.jbi.transaction.jta");
            if (object != null && object.getStatus() == 0) {
                transactionContext = object.getPropagationContext(false);
            }
        } else if (current.getStatus() == 0) {
            transactionContext = current.getPropagationContext(false);
        }
        if (transactionContext != null) {
            object = new PetalsTransactionContext();
            Xid xid = transactionContext.getXid();
            object.formatID = xid.getFormatId();
            object.globalTransactionID = xid.getGlobalTransactionId();
            object.branchQualifier = xid.getBranchQualifier();
            object.coordinator = transactionContext.getCoordinator();
            object.timeOut = transactionContext.getTimeout();
            messageExchangeDecorator.setProperty("javax.jbi.transaction.jta", object);
            messageExchangeDecorator.setTransacted(true);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        current.begin();
        TransactionContext transactionContext = current.getPropagationContext(false);
        if (transactionContext.getCoordinator() == null) {
            Coordinator coordinator;
            try {
                coordinator = (Coordinator)PortableRemoteObject.narrow((Object)PortableRemoteObject.toStub((Remote)Current.getJTM().recreate(transactionContext)), Coordinator.class);
            }
            catch (RemoteException remoteException) {
                throw new SystemException(remoteException.getMessage());
            }
            transactionContext.setCoordinator(coordinator);
            transactionContext.setTerminator((Terminator)coordinator);
        }
    }

    public void commit() throws IllegalStateException, SecurityException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        current.commit();
    }

    public int getStatus() throws SystemException {
        return current.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return current.getTransaction();
    }

    public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
        current.resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        current.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        current.setRollbackOnly();
    }

    public void setTransactionTimeout(int n) throws SystemException {
        current.setTransactionTimeout(n);
    }

    public Transaction suspend() throws SystemException {
        return current.suspend();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        try {
            current = new Current((TransactionFactory)new TransactionFactoryImpl());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

