/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.SystemException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.commons.threadlocal.Transformers;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.management.transaction.TransactionManagerImpl;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeFactoryImpl;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.util.LoggingUtil;

public class DeliveryChannelImpl
implements DeliveryChannel {
    protected ComponentContext componentContext;
    protected LoggingUtil log;
    protected Logger logger;
    protected MessageExchangeFactoryImpl messageExchangeFactory;
    protected boolean opened = true;

    public DeliveryChannelImpl(ComponentContext componentContext) {
        this.logger = componentContext.getLogger();
        this.log = new LoggingUtil(this.logger);
        this.messageExchangeFactory = new MessageExchangeFactoryImpl(this, componentContext.getAddress(), this.logger);
        this.componentContext = componentContext;
    }

    private static final void checkMessageExchange(MessageExchangeDecorator messageExchangeDecorator) throws MessagingException {
        if (messageExchangeDecorator == null) {
            throw new MessagingException("MessageExchange is null");
        }
        MessageExchangeDecorator messageExchangeDecorator2 = messageExchangeDecorator;
        if (messageExchangeDecorator2.getMessageExchange().isTerminated()) {
            throw new MessagingException("MessageExchange is terminated, it can not be sent any more");
        }
    }

    public MessageExchange accept() throws MessagingException {
        this.log.call();
        MessageExchange messageExchange = this.poll(-1L);
        return messageExchange;
    }

    public MessageExchange accept(long l) throws MessagingException {
        this.log.call((Object)l);
        if (l < 0L) {
            throw new MessagingException("Timeout must be positive");
        }
        MessageExchange messageExchange = this.poll(l);
        return messageExchange;
    }

    public void checkDeliveryChannelIsOpened() throws MessagingException {
        if (!this.opened) {
            throw new MessagingException("DeliveryChannel is closed");
        }
    }

    public synchronized void close() throws MessagingException {
        this.log.start();
        this.checkDeliveryChannelIsOpened();
        this.opened = false;
        this.log.end();
    }

    public MessageExchangeFactory createExchangeFactory() {
        this.log.call();
        MessageExchangeFactoryImpl messageExchangeFactoryImpl = new MessageExchangeFactoryImpl(this, this.componentContext.getAddress(), this.logger);
        return messageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(QName qName) {
        this.log.call((Object)qName);
        return new MessageExchangeFactoryImpl(this, this.componentContext.getAddress(), this.logger, qName, null, null);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint serviceEndpoint) {
        this.log.call((Object)serviceEndpoint);
        return new MessageExchangeFactoryImpl(this, this.componentContext.getAddress(), this.logger, null, null, serviceEndpoint);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName qName) {
        this.log.call((Object)qName);
        return new MessageExchangeFactoryImpl(this, this.componentContext.getAddress(), this.logger, null, qName, null);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void send(MessageExchange messageExchange) throws MessagingException {
        this.log.call((Object)("Exchange Id:" + messageExchange.getExchangeId()));
        this.sendExchange((MessageExchangeDecorator)messageExchange, 0L, false);
    }

    public boolean sendSync(MessageExchange messageExchange) throws MessagingException {
        return this.sendSync(messageExchange, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendSync(MessageExchange var1_1, long var2_2) throws MessagingException {
        block5: {
            this.log.call((Object)("Exchange Id:" + var1_1.getExchangeId() + " - Timeout:" + var2_2));
            var4_3 = false;
            var5_4 = (MessageExchangeDecorator)var1_1;
            try {
                this.sendExchange(var5_4, var2_2, true);
                if (var5_4.isTimeout()) {
                    var5_4.setTimeout(false);
                    var4_3 = true;
                }
                break block5;
            }
            catch (MessagingException var6_5) {
                this.log.debug((Object)var6_5.getMessage());
                var5_4.setStatus(ExchangeStatus.ERROR);
                var5_4.getMessageExchange().setTerminated(true);
                var7_6 = var6_5.getCause();
                ** while (var7_6 != null)
            }
lbl-1000:
            // 1 sources

            {
                if (var7_6 instanceof InterruptedException) {
                    this.log.end();
                    return false;
                }
                var7_6 = var7_6.getCause();
                continue;
            }
lbl21:
            // 1 sources

            throw var6_5;
        }
        this.log.end();
        return var4_3 == false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logMessage(MessageExchangeDecorator messageExchangeDecorator) {
        java.util.logging.Logger logger = null;
        try {
            logger = this.componentContext.getLogger("", null);
            if (!logger.isLoggable(Level.FINEST)) return;
            if (ExchangeStatus.ACTIVE.equals(messageExchangeDecorator.getStatus())) {
                Object object;
                Object object2;
                NormalizedMessage normalizedMessage;
                block16: {
                    block14: {
                        InputStream inputStream;
                        Source source;
                        block15: {
                            normalizedMessage = messageExchangeDecorator.getMessage("out");
                            String string = "out";
                            if (normalizedMessage == null) {
                                normalizedMessage = messageExchangeDecorator.getFault();
                                string = "Fault";
                            }
                            if (normalizedMessage == null) {
                                normalizedMessage = messageExchangeDecorator.getMessage("in");
                                string = "in";
                            }
                            logger.finest("Message " + string + " with Id '" + messageExchangeDecorator.getExchangeId() + "' to send");
                            logger.finest("Operation : " + messageExchangeDecorator.getOperation());
                            logger.finest("MEP : " + messageExchangeDecorator.getPattern());
                            object2 = normalizedMessage.getPropertyNames().iterator();
                            while (true) {
                                if (!object2.hasNext()) {
                                    source = normalizedMessage.getContent();
                                    if (source == null) break block14;
                                    if (source instanceof StreamSource) {
                                        object = (StreamSource)source;
                                        inputStream = ((StreamSource)object).getInputStream();
                                        object2 = inputStream != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(((StreamSource)object).getReader()));
                                    }
                                    break block15;
                                }
                                source = object2.next();
                                logger.finest("Message property '" + source + "' : " + normalizedMessage.getProperty((String)((Object)source)));
                            }
                            normalizedMessage.setContent((Source)new StreamSource(object2.getInputStreamOne()));
                            source = new StreamSource(object2.getInputStreamTwo());
                        }
                        object2 = Transformers.getDefaultTransformer();
                        ((Transformer)object2).setOutputProperty("encoding", Charset.defaultCharset().name());
                        object = new ByteArrayOutputStream();
                        try {
                            ((Transformer)object2).transform(source, new StreamResult((OutputStream)object));
                        }
                        catch (Throwable throwable) {
                            inputStream = null;
                            ((Transformer)object2).reset();
                            throw throwable;
                        }
                        {
                            inputStream = null;
                            ((Transformer)object2).reset();
                            logger.finest("Message Content : " + new String(((ByteArrayOutputStream)object).toByteArray()));
                            break block16;
                        }
                    }
                    logger.finest("Message Content is null");
                }
                object = normalizedMessage.getAttachmentNames().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        return;
                    }
                    object2 = object.next();
                    logger.finest("Got a message attachment named '" + object2 + "'");
                }
            }
            if (ExchangeStatus.DONE.equals(messageExchangeDecorator.getStatus())) {
                logger.finest("Message acknowledgement DONE with Id '" + messageExchangeDecorator.getExchangeId() + "' to send");
                return;
            }
            logger.finest("Message acknowledgement ERROR with Id '" + messageExchangeDecorator.getExchangeId() + "' to send");
            logger.finest("Message Error : " + messageExchangeDecorator.getError().getMessage());
            return;
        }
        catch (Throwable throwable) {
            if (logger == null) return;
            logger.fine("failed to log the content of the message to send: " + throwable.getMessage());
        }
    }

    private MessageExchange poll(long l) throws MessagingException {
        this.log.start();
        this.checkDeliveryChannelIsOpened();
        MessageExchangeDecorator messageExchangeDecorator = null;
        try {
            messageExchangeDecorator = this.componentContext.getRouter().receive(this.componentContext, l);
        }
        catch (RoutingException routingException) {
            throw new MessagingException((Throwable)((Object)routingException));
        }
        if (messageExchangeDecorator != null && this.componentContext.getTransactionManager() != null) {
            TransactionManagerImpl.decodeTransactionContext(messageExchangeDecorator);
        }
        this.log.end();
        return messageExchangeDecorator;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendExchange(MessageExchangeDecorator messageExchangeDecorator, long l, boolean bl) throws MessagingException {
        this.checkDeliveryChannelIsOpened();
        DeliveryChannelImpl.checkMessageExchange(messageExchangeDecorator);
        this.logMessage(messageExchangeDecorator);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (!ExchangeStatus.ACTIVE.equals(messageExchangeDecorator.getStatus())) {
                    messageExchangeDecorator.setTerminated(true);
                    if (bl) {
                        throw new MessagingException("Sending an acknowledgment in synchronous mode is forbidden");
                    }
                }
                if (this.componentContext.getTransactionManager() != null) {
                    TransactionManagerImpl.encodeTransactionContext(messageExchangeDecorator);
                }
                if (bl) {
                    this.componentContext.getRouter().sendSync(this.componentContext, messageExchangeDecorator, l);
                    if (!messageExchangeDecorator.isTimeout() && this.componentContext.getTransactionManager() != null) {
                        TransactionManagerImpl.decodeTransactionContext(messageExchangeDecorator);
                    }
                } else {
                    this.componentContext.getRouter().send(this.componentContext, messageExchangeDecorator);
                }
            }
            catch (JBIException jBIException) {
                throw new MessagingException((Throwable)jBIException);
            }
            catch (SystemException systemException) {
                throw new MessagingException((Throwable)systemException);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var7_9 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.log.end();
    }
}

